/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.vlib.structure;

import g_mungus.vlib.VLib;
import g_mungus.vlib.data.StructureSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u0012\u0006\u0010\u001c\u001a\u00020\u0004\u0012\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b*\u0010+J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010!\u001a\u00020 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lg_mungus/vlib/structure/TemplateAssemblyData;", "", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lnet/minecraft/core/BlockPos;", "shipCenter", "", "callback", "(Lorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/core/BlockPos;)V", "", "location", "getName", "(Ljava/lang/String;)Ljava/lang/String;", "Lkotlin/random/Random;", "random", "Lorg/joml/Quaterniond;", "randomQuaternion", "(Lkotlin/random/Random;)Lorg/joml/Quaterniond;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/server/level/ServerLevel;", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "Lg_mungus/vlib/data/StructureSettings;", "structureSettings", "Lg_mungus/vlib/data/StructureSettings;", "getStructureSettings", "()Lg_mungus/vlib/data/StructureSettings;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;", "template", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;", "getTemplate", "()Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;", "<init>", "(Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lg_mungus/vlib/data/StructureSettings;)V", "vlib"})
@SourceDebugExtension(value={"SMAP\nTemplateAssemblyData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateAssemblyData.kt\ng_mungus/vlib/structure/TemplateAssemblyData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class TemplateAssemblyData {
    @NotNull
    private final StructureTemplate template;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final BlockPos pos;
    @NotNull
    private final StructureSettings structureSettings;

    public TemplateAssemblyData(@NotNull StructureTemplate template, @NotNull ResourceLocation id, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull StructureSettings structureSettings) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)structureSettings, (String)"structureSettings");
        this.template = template;
        this.id = id;
        this.level = level;
        this.pos = pos;
        this.structureSettings = structureSettings;
    }

    @NotNull
    public final StructureTemplate getTemplate() {
        return this.template;
    }

    @NotNull
    public final ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public final ServerLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @NotNull
    public final StructureSettings getStructureSettings() {
        return this.structureSettings;
    }

    public final void callback(@NotNull Ship ship, @NotNull BlockPos shipCenter) {
        Quaterniond quaterniond;
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)shipCenter, (String)"shipCenter");
        if (Intrinsics.areEqual((Object)this.structureSettings.getRename(), (Object)true)) {
            String string = this.id.m_135815_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String name = this.getName(string);
            if (name != null) {
                ((ServerShip)ship).setSlug(name);
            } else {
                VLib.INSTANCE.getLOGGER().warn("Failed to rename ship");
            }
        }
        if (this.structureSettings.getRandomRotation()) {
            Random random = RandomKt.Random((long)this.pos.m_121878_());
            quaterniond = this.randomQuaternion(random);
        } else {
            quaterniond = new Quaterniond();
        }
        Quaterniond rot = quaterniond;
        Vector3d vector3d = ship.getTransform().getPositionInWorld().add(((ServerShip)ship).getInertiaData().getCenterOfMassInShip(), new Vector3d()).sub((double)shipCenter.m_123341_(), (double)shipCenter.m_123342_(), (double)shipCenter.m_123343_());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"sub(...)");
        Vector3d newPos = vector3d;
        VSGameUtilsKt.getShipObjectWorld((ServerLevel)this.level).teleportShip((ServerShip)ship, (ShipTeleportData)new ShipTeleportDataImpl((Vector3dc)newPos, (Quaterniondc)rot, null, null, null, null, 60, null));
        if (!Intrinsics.areEqual((Object)this.structureSettings.getStatic(), (Object)true)) {
            ((ServerShip)ship).setStatic(false);
        }
    }

    private final String getName(String location) {
        String string;
        int i = StringsKt.lastIndexOf$default((CharSequence)location, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (i >= 0) {
            String string2 = location.substring(i + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            CharSequence charSequence;
            CharSequence charSequence2 = location;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        }
        return string;
    }

    private final Quaterniond randomQuaternion(Random random) {
        double u1 = random.nextDouble();
        double u2 = random.nextDouble();
        double u3 = random.nextDouble();
        double sqrt1MinusU1 = Math.sqrt(1.0 - u1);
        double sqrtU1 = Math.sqrt(u1);
        double twoPiU2 = Math.PI * 2 * u2;
        double twoPiU3 = Math.PI * 2 * u3;
        double x = sqrt1MinusU1 * Math.sin(twoPiU2);
        double y = sqrt1MinusU1 * Math.cos(twoPiU2);
        double z = sqrtU1 * Math.sin(twoPiU3);
        double w = sqrtU1 * Math.cos(twoPiU3);
        return new Quaterniond(x, y, z, w);
    }
}

