/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.vlib.structure;

import g_mungus.vlib.VLib;
import g_mungus.vlib.data.DimensionSettings;
import g_mungus.vlib.data.StructureSettings;
import g_mungus.vlib.dimension.DimensionSettingsManager;
import g_mungus.vlib.structure.TemplateAssemblyData;
import g_mungus.vlib.util.CanRemoveTemplate;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b'\u0010\u0012J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\fJ\u0019\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR#\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lg_mungus/vlib/structure/StructureManager;", "", "", "namespace", "Lg_mungus/vlib/data/StructureSettings;", "structureSettings", "", "addModifiedStructures", "(Ljava/lang/String;Lg_mungus/vlib/data/StructureSettings;)V", "Lg_mungus/vlib/structure/TemplateAssemblyData;", "data", "createShipFromTemplate", "(Lg_mungus/vlib/structure/TemplateAssemblyData;)V", "enqueueTemplateForAssembly", "", "getModifiedStructures", "()Ljava/util/Map;", "resetModifiedStructures", "()V", "DIRTY", "Ljava/lang/String;", "READY", "Ljava/util/Queue;", "assemblyQueue", "Ljava/util/Queue;", "getAssemblyQueue", "()Ljava/util/Queue;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/minecraft/core/BlockPos;", "", "blacklist", "Ljava/util/concurrent/ConcurrentHashMap;", "getBlacklist", "()Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/locks/ReentrantLock;", "blacklistMutex", "Ljava/util/concurrent/locks/ReentrantLock;", "modifiedStructures", "Ljava/util/Map;", "<init>", "vlib"})
public final class StructureManager {
    @NotNull
    public static final StructureManager INSTANCE = new StructureManager();
    @NotNull
    private static volatile Map<String, StructureSettings> modifiedStructures = MapsKt.emptyMap();
    @NotNull
    private static final Queue<TemplateAssemblyData> assemblyQueue = new ConcurrentLinkedQueue();
    @NotNull
    private static final ConcurrentHashMap<BlockPos, Long> blacklist = new ConcurrentHashMap();
    @NotNull
    private static final ReentrantLock blacklistMutex = new ReentrantLock();
    @NotNull
    public static final String READY = "vlib$ready";
    @NotNull
    public static final String DIRTY = "vlib$dirty";

    private StructureManager() {
    }

    @NotNull
    public final Queue<TemplateAssemblyData> getAssemblyQueue() {
        return assemblyQueue;
    }

    @NotNull
    public final ConcurrentHashMap<BlockPos, Long> getBlacklist() {
        return blacklist;
    }

    public final void addModifiedStructures(@NotNull String namespace, @NotNull StructureSettings structureSettings) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)structureSettings, (String)"structureSettings");
        Map modifiedStructures = MapsKt.toMutableMap(StructureManager.modifiedStructures);
        modifiedStructures.put(namespace, structureSettings);
        StructureManager.modifiedStructures = modifiedStructures;
    }

    public final void resetModifiedStructures() {
        modifiedStructures = MapsKt.emptyMap();
    }

    @NotNull
    public final Map<String, StructureSettings> getModifiedStructures() {
        return MapsKt.toMap(modifiedStructures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueTemplateForAssembly(@NotNull TemplateAssemblyData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (VLib.isDuringWorldGen()) {
            long now = new Date().getTime();
            blacklistMutex.lock();
            try {
                if (blacklist.putIfAbsent(data.getPos(), now) != null) {
                    return;
                }
            }
            finally {
                blacklistMutex.unlock();
            }
        }
        assemblyQueue.add(data);
        VLib.INSTANCE.getLOGGER().info("enqueueing template at " + data.getPos());
    }

    public final void createShipFromTemplate(@NotNull TemplateAssemblyData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        BlockPos pos = data.getPos();
        if (data.getLevel().m_151570_(pos)) {
            pos = new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
        }
        DimensionSettings dimensionSettings = DimensionSettingsManager.INSTANCE.getSettingsForLevel(VSGameUtilsKt.getDimensionId((Level)((Level)data.getLevel())));
        ServerShip ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)data.getLevel()).createNewShipAtBlock((Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)((Vec3i)pos)), false, dimensionSettings.getShipScale(), VSGameUtilsKt.getDimensionId((Level)((Level)data.getLevel())));
        ship.setStatic(true);
        BlockPos centreOfShip = VectorConversionsMCKt.toBlockPos((Vector3ic)((Vector3ic)ship.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)((Level)data.getLevel())), new Vector3i()))).m_175288_(pos.m_123342_());
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        structurePlaceSettings.m_74385_(centreOfShip);
        data.getTemplate().m_230328_((ServerLevelAccessor)data.getLevel(), centreOfShip, centreOfShip, structurePlaceSettings, RandomSource.m_216327_(), 2);
        if (ship.getInertiaData().getMass() < 0.001) {
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)data.getLevel()).deleteShip(ship);
            VLib.INSTANCE.getLOGGER().warn("Deleting ship with id: " + ship.getId() + " because it has mass 0");
        } else {
            if (!Intrinsics.areEqual((Object)pos, (Object)data.getPos())) {
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)data.getLevel()).teleportShip(ship, (ShipTeleportData)new ShipTeleportDataImpl((Vector3dc)new Vector3d((double)data.getPos().m_123341_(), (double)data.getPos().m_123342_(), (double)data.getPos().m_123343_()), null, null, null, null, null, 62, null));
            }
            Ship ship2 = (Ship)ship;
            Intrinsics.checkNotNull((Object)centreOfShip);
            data.callback(ship2, centreOfShip);
        }
        StructureTemplateManager structureTemplateManager = data.getLevel().m_215082_();
        Intrinsics.checkNotNullExpressionValue((Object)structureTemplateManager, (String)"getStructureManager(...)");
        StructureTemplateManager manager = structureTemplateManager;
        if (((CanRemoveTemplate)manager).vlib$unloadTemplate(data.getTemplate())) {
            VLib.INSTANCE.getLOGGER().info("Structure templates cleaned.");
        } else {
            VLib.INSTANCE.getLOGGER().error("Structure template cleanup failed");
        }
    }
}

