/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch;

import bl4ckscor3.mod.ceilingtorch.CompatConfig;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.vanilla.VanillaCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="ceilingtorch")
@EventBusSubscriber
public class CeilingTorch {
    public static final String MODID = "ceilingtorch";
    private static final Map<String, ICeilingTorchCompat> COMPAT_LIST = new HashMap<String, ICeilingTorchCompat>();
    private static Map<String, Supplier<ICeilingTorchCompat>> preliminaryCompatList = new HashMap<String, Supplier<ICeilingTorchCompat>>();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ceilingtorch");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"ceilingtorch");
    private static boolean initialized = false;

    public CeilingTorch(IEventBus modBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)CompatConfig.CONFIG_SPEC, "ceiling-torch-integrations.toml");
        BLOCKS.register(modBus);
        BLOCK_ENTITIES.register(modBus);
        preliminaryCompatList.put("minecraft", VanillaCompat::new);
        CompatConfig.CONFIG.getBuiltInCompat().forEach((modid, compatInfo) -> {
            if (((Boolean)compatInfo.config().get()).booleanValue() && ModList.get().isLoaded(modid)) {
                preliminaryCompatList.put((String)modid, compatInfo.ceilingTorchCompat().get());
            }
        });
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        if (!initialized) {
            for (Map.Entry<String, Supplier<ICeilingTorchCompat>> entry : preliminaryCompatList.entrySet()) {
                COMPAT_LIST.put(entry.getKey(), entry.getValue().get());
            }
            initialized = true;
            preliminaryCompatList = null;
        }
    }

    public static void addCompat(String modid, Supplier<ICeilingTorchCompat> compat) {
        if (ModList.get().isLoaded(modid)) {
            preliminaryCompatList.put(modid, compat);
        }
    }

    public static Map<String, ICeilingTorchCompat> getCompatList() {
        return COMPAT_LIST;
    }

    public static ResourceLocation getRegistryName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static boolean isModCompatActive(String modid) {
        return (Boolean)CompatConfig.CONFIG.getBuiltInCompat().get(modid).config().get() != false && ModList.get().isLoaded(modid);
    }
}

