/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch;

import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.bonetorch.BoneTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.tofucraft.TofuCraftCompat;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CompatConfig {
    public static final String FILE_NAME = "ceiling-torch-integrations.toml";
    public static final ModConfigSpec CONFIG_SPEC;
    public static final CompatConfig CONFIG;
    private Map<String, CompatInfo> builtInCompat;

    CompatConfig(ModConfigSpec.Builder builder) {
        builder.comment(new String[]{"This configuration is meant to allow turning off mod integration that has stopped working. All integrations are enabled by default. To disable a specific integration, set the relevant config value to \"false\".", "Should you encounter any crashes when using Ceiling Torch, please report them to https://github.com/bl4ckscor3/CeilingTorch/issues", "If you turn off a mod integration using this config, you can continue playing without needing an update of Ceiling Torch; However do note that the ceiling torches from that integration will disappear from your world. Note, that if you do not place a block in a space where a ceiling torch was, and then re-enable the respective integration, the torch will reappear.", "Turning off integration with a mod that you are not using will not have any effect, as Ceiling Torch automatically checks for the presence of mods it integrates with."});
        this.builtInCompat = Map.ofEntries(this.makeEntry(builder, "bonetorch", () -> BoneTorchCompat::new), this.makeEntry(builder, "tofucraft", () -> TofuCraftCompat::new));
    }

    private Map.Entry<String, CompatInfo> makeEntry(ModConfigSpec.Builder builder, String modid, Supplier<Supplier<ICeilingTorchCompat>> ceilingTorchCompat) {
        return Map.entry(modid, new CompatInfo(builder.define(modid, true), ceilingTorchCompat));
    }

    private Map.Entry<String, CompatInfo> makeEntry(ModConfigSpec.Builder builder, String modid, String comment, Supplier<Supplier<ICeilingTorchCompat>> ceilingTorchCompat) {
        return Map.entry(modid, new CompatInfo(builder.comment(comment).define(modid, true), ceilingTorchCompat));
    }

    public Map<String, CompatInfo> getBuiltInCompat() {
        return this.builtInCompat;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CompatConfig::new);
        CONFIG_SPEC = (ModConfigSpec)specPair.getRight();
        CONFIG = (CompatConfig)specPair.getLeft();
    }

    public record CompatInfo(ModConfigSpec.BooleanValue config, Supplier<Supplier<ICeilingTorchCompat>> ceilingTorchCompat) {
    }
}

