/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch;

import bl4ckscor3.mod.ceilingtorch.CeilingTorch;
import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="ceilingtorch")
public class PlaceHandler {
    private PlaceHandler() {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().isSpectator()) {
            BlockPos pos = event.getPos();
            Direction face = event.getFace();
            BlockPos placeAt = pos.relative(face);
            Level level = event.getLevel();
            if (face == Direction.DOWN && (level.isEmptyBlock(placeAt) || !level.getFluidState(placeAt).isEmpty())) {
                ICeilingTorchCompat compat;
                Map<ResourceLocation, Block> placeEntries;
                String modid;
                ItemStack held = event.getItemStack();
                ResourceLocation rl = CeilingTorch.getRegistryName(held.getItem());
                Map<String, ICeilingTorchCompat> compatList = CeilingTorch.getCompatList();
                if (compatList.containsKey(modid = rl.getNamespace()) && (placeEntries = (compat = compatList.get(modid)).getPlaceEntries()).containsKey(rl)) {
                    PlaceHandler.placeTorch(compat, event, held, placeAt, level, placeEntries.get(rl).defaultBlockState());
                }
            }
        }
    }

    public static boolean placeTorch(ICeilingTorchCompat compat, PlayerInteractEvent.RightClickBlock event, ItemStack held, BlockPos placeAt, Level level, BlockState state) {
        if ((state = compat.getStateToPlace(event, level, placeAt, state, held)).canSurvive((LevelReader)level, placeAt)) {
            level.setBlockAndUpdate(placeAt, state);
            compat.onPlace(event, placeAt, state);
            SoundType soundType = state.getBlock().getSoundType(state, (LevelReader)level, placeAt, (Entity)event.getEntity());
            level.playSound(null, (double)placeAt.getX(), (double)placeAt.getY(), (double)placeAt.getZ(), soundType.getPlaceSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch() - 0.2f);
            event.getEntity().swing(event.getHand());
            if (!event.getEntity().isCreative()) {
                held.shrink(1);
            }
            NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)placeAt), level.getBlockState(event.getPos()), (Entity)event.getEntity()));
            return true;
        }
        return false;
    }
}

