/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.vanilla;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneCeilingTorchBlock
extends RedstoneTorchBlock {
    private final Supplier<Block> originalBlock;

    public RedstoneCeilingTorchBlock(BlockBehaviour.Properties properties, Supplier<Block> originalBlock) {
        super(properties);
        this.originalBlock = originalBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CeilingTorchBlock.CEILING_SHAPE;
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return facing == Direction.UP && !this.canSurvive(state, level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return RedstoneCeilingTorchBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public int getSignal(BlockState state, BlockGetter access, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)LIT) != false && Direction.DOWN != side ? 15 : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter access, BlockPos pos, Direction side) {
        return side == Direction.UP ? state.getSignal(access, pos, side) : 0;
    }

    protected boolean hasNeighborSignal(Level world, BlockPos pos, BlockState state) {
        return world.hasSignal(pos.above(), Direction.UP);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double x = (double)pos.getX() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double y = (double)pos.getY() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double z = (double)pos.getZ() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y - 0.25, z, 0.0, 0.0, 0.0);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return new ItemStack((ItemLike)this.originalBlock.get());
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Optional drops = this.getOriginalBlock().getLootTable();
        if (drops.isEmpty()) {
            return Collections.emptyList();
        }
        LootParams lootParams = params.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
        ServerLevel level = lootParams.getLevel();
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable((ResourceKey)drops.get());
        return lootTable.getRandomItems(lootParams);
    }

    public Block getOriginalBlock() {
        return this.originalBlock.get();
    }
}

