/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.burninthesun;

import com.kreezcraft.burninthesun.Constants;
import com.kreezcraft.burninthesun.platform.Services;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class CommonClass {
    public static void onEntityUpdate(LivingEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide()) {
            BlockPos blockpos = entity.blockPosition();
            if (level.isDarkOutside()) {
                return;
            }
            if (CommonClass.isInvalidDimension(level)) {
                return;
            }
            if (!level.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.above();
            }
            if (entity instanceof Player) {
                return;
            }
            ResourceLocation fullId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            assert (fullId != null);
            if ((Services.PLATFORM.getTanningLotion() || Constants.canBurn(fullId)) && level.canSeeSky(blockpos) && level.isBrightOutside() && !entity.isOnFire() && !entity.isInWater() && !level.isRainingAt(blockpos) && !CommonClass.isProtectedAgainstFire(entity)) {
                entity.igniteForSeconds(1.0f);
            }
        }
    }

    public static void onPlayerUpdate(Player player) {
        Level level = player.level();
        if (!level.isClientSide()) {
            MinecraftServer server;
            BlockPos blockpos = player.blockPosition();
            if (player.isCreative()) {
                return;
            }
            if (Services.PLATFORM.getNoOpBurn() && (server = player.level().getServer()) != null && !server.isSingleplayer() && player != null && server.getPlayerList().isOp(player.nameAndId())) {
                return;
            }
            Object debugMsg = "";
            if (level.isDarkOutside()) {
                return;
            }
            if (CommonClass.isInvalidDimension(level)) {
                return;
            }
            if (!level.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.above();
            }
            if (Services.PLATFORM.getTanningLotion() || Services.PLATFORM.getBurnPlayers()) {
                debugMsg = (String)debugMsg + "tanninglotion or burnplayers is enabled, ";
                if (level.canSeeSky(blockpos)) {
                    List<? extends String> ignoredBlocks = Services.PLATFORM.getIgnoredBlocks();
                    if (!ignoredBlocks.isEmpty()) {
                        BlockPos topPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).below();
                        BlockState state = level.getBlockState(topPos);
                        ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
                        if (!state.isAir() && ignoredBlocks.contains(blockKey.toString())) {
                            debugMsg = (String)debugMsg + "player is standing under an ignored block, ";
                            return;
                        }
                    }
                    debugMsg = (String)debugMsg + "player can see sky, ";
                    if (level.isBrightOutside() && !level.isRainingAt(blockpos)) {
                        debugMsg = (String)debugMsg + "is day, not raining, ";
                        if (!(player.isOnFire() || player.isInWater() || CommonClass.isProtectedAgainstFire((LivingEntity)player))) {
                            debugMsg = (String)debugMsg + "not burning, not in water.";
                            player.igniteForSeconds(1.0f);
                        }
                    }
                }
            }
        }
    }

    private static boolean isInvalidDimension(Level level) {
        List<? extends String> dimensions = Services.PLATFORM.getDimensions();
        String currentDimension = level.dimension().location().toString();
        return Services.PLATFORM.invertDimensions() == dimensions.contains(currentDimension);
    }

    private static boolean isProtectedAgainstFire(LivingEntity livingEntity) {
        ItemStack itemstack;
        if (Services.PLATFORM.checkArmor() && !(itemstack = livingEntity.getItemBySlot(EquipmentSlot.HEAD)).isEmpty()) {
            if (Services.PLATFORM.damageArmor()) {
                boolean shouldDamage;
                boolean bl = shouldDamage = itemstack.isDamageableItem() && livingEntity.getRandom().nextFloat() * 30.0f < (livingEntity.getLightLevelDependentMagicValue() - 0.4f) * 2.0f;
                if (shouldDamage) {
                    itemstack.setDamageValue(itemstack.getDamageValue() + livingEntity.getRandom().nextInt(2));
                    if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                        livingEntity.onEquippedItemBroken(itemstack.getItem(), EquipmentSlot.HEAD);
                        livingEntity.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
            }
            return true;
        }
        if (Services.PLATFORM.checkEffects()) {
            return livingEntity.hasEffect(MobEffects.FIRE_RESISTANCE);
        }
        return false;
    }
}

