/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.burninthesun.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ModConfigSpec spec = BUILDER.build();

    public static class General {
        public final ModConfigSpec.BooleanValue tanningLotion;
        public final ModConfigSpec.BooleanValue burnPlayers;
        public final ModConfigSpec.BooleanValue noOpBurn;
        public final ModConfigSpec.BooleanValue showConsoleIDS;
        public final ModConfigSpec.BooleanValue checkArmor;
        public final ModConfigSpec.BooleanValue damageArmor;
        public final ModConfigSpec.BooleanValue checkEffects;
        private static final List<String> defaultMods = new ArrayList<String>(List.of("iceandfire"));
        private static final List<String> defaultMobs = new ArrayList<String>(List.of("minecraft:chicken", "minecraft:cow", "minecraft:stray"));
        public final ModConfigSpec.ConfigValue<List<? extends String>> mods;
        public final ModConfigSpec.ConfigValue<List<? extends String>> mobs;
        public final ModConfigSpec.ConfigValue<List<? extends String>> ignoredBlocks;
        public final ModConfigSpec.BooleanValue invertDimensions;
        public final ModConfigSpec.ConfigValue<List<? extends String>> dimensions;

        public General(ModConfigSpec.Builder builder) {
            builder.push("General");
            this.showConsoleIDS = builder.comment("If enabled your console will fill with spam showing the various types of data you will need to fine tune this config").translation("config.showConsoleIDS").define("showConsoleIDS", false);
            this.tanningLotion = builder.comment("If selected the rest of the config is pointless. Default: false").translation("config.tanningLotion").define("tanningLotion", false);
            this.burnPlayers = builder.comment("Should players burn? Default: false").translation("config.burnPlayers").define("burnPlayers", false);
            this.noOpBurn = builder.comment("Should ops NOT burn? Default: true").translation("config.noOpBurn").define("noOpBurn", true);
            this.checkArmor = builder.comment("If enabled armor in the head slot will prevent burning. Default: false").translation("config.checkArmor").define("checkArmor", false);
            this.damageArmor = builder.comment("If enabled armor will take damage if 'checkArmor' is enabled. Default: false").translation("config.checkArmor").define("damageArmor", false);
            this.checkEffects = builder.comment("If enabled effects will be checked to see if they prevent burning. Default: false").translation("config.checkEffects").define("checkEffects", false);
            this.mods = builder.comment("Allow all of a mods' mobs from burning just by specifying the modid. Comma separated and quoted list\nDefault: \"iceandfire\"").translation("config.modids").defineListAllowEmpty(List.of("mods"), () -> defaultMods, () -> "", o -> o instanceof String);
            this.mobs = builder.comment("Allows specific mods' mobs to burn just by specifying their full id for example modid:mobname.  Comma separated and quoted list\nDefault: \"minecraft:zombie\",\"minecraft:skeleton\"").translation("config.modids").defineListAllowEmpty(List.of("mobs"), () -> defaultMobs, () -> "", o -> {
                String string;
                return o instanceof String && ResourceLocation.tryParse((String)(string = (String)o)) != null;
            });
            this.ignoredBlocks = builder.comment("Allows specific mods' blocks to be ignored while checking if you are able to see the sky by specifying their full id for example modid:blockname.  Comma separated and quoted list\nExample: \"minecraft:black_stained_glass\"").translation("config.modids").defineListAllowEmpty(List.of("ignoredBlocks"), ArrayList::new, () -> "", o -> {
                String string;
                return o instanceof String && ResourceLocation.tryParse((String)(string = (String)o)) != null;
            });
            this.invertDimensions = builder.comment("If enabled the `dimensions` list will become a blacklist. Default: true").translation("config.invertDimensions").define("invertDimensions", true);
            this.dimensions = builder.comment("Specify dimensions that allow sun burning by specifying their full id for example modid:dimensionname. (If `invertDimensions` is set to true this turns into a dimension blacklist) \nExample: \"minecraft:overworld\"").translation("config.dimensions").defineListAllowEmpty(List.of("dimensions"), ArrayList::new, () -> "", o -> {
                String string;
                return o instanceof String && ResourceLocation.tryParse((String)(string = (String)o)) != null;
            });
        }
    }
}

