/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.planeadvancements;

import com.nettakrim.planeadvancements.AdvancementWidgetInterface;
import com.nettakrim.planeadvancements.PlaneAdvancementsClient;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_3532;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class AdvancementCluster {
    public final Vector2f pos;
    public final Vector2i size;
    protected final float offsetY;
    protected final AdvancementWidgetInterface root;

    public AdvancementCluster(AdvancementWidgetInterface root) {
        this(root, root.planeAdvancements$isRoot() ? root : null);
    }

    public AdvancementCluster(AdvancementWidgetInterface root, AdvancementWidgetInterface ignoreChildrenFrom) {
        Vector3f size = AdvancementCluster.getClusterSize(root, ignoreChildrenFrom);
        this.pos = new Vector2f(0.0f, 0.0f);
        this.size = new Vector2i(class_3532.method_15386((float)size.x), class_3532.method_15386((float)(size.z - size.y + 1.0f)));
        this.offsetY = -size.y;
        this.root = root;
        root.planeAdvancements$setClusterRoot(true);
    }

    public static Vector3f getClusterSize(AdvancementWidgetInterface root, AdvancementWidgetInterface ignoreChildrenFrom) {
        if (root == ignoreChildrenFrom) {
            return new Vector3f(1.0f, 0.0f, 0.0f);
        }
        float widthMax = 1.0f;
        float heightMax = 0.0f;
        float heightMin = 0.0f;
        float rootX = root.planeAdvancements$getDisplay().method_818() - 1.0f;
        float rootY = root.planeAdvancements$getDisplay().method_819();
        Stack<AdvancementWidgetInterface> stack = new Stack<AdvancementWidgetInterface>();
        stack.addAll(root.planeAdvancements$getChildren());
        while (!stack.isEmpty()) {
            float height;
            float width;
            AdvancementWidgetInterface advancement = (AdvancementWidgetInterface)stack.pop();
            if (advancement != ignoreChildrenFrom) {
                stack.addAll(advancement.planeAdvancements$getChildren());
            }
            if ((width = advancement.planeAdvancements$getDisplay().method_818() - rootX) > widthMax) {
                widthMax = width;
            }
            if ((height = advancement.planeAdvancements$getDisplay().method_819() - rootY) > heightMax) {
                heightMax = height;
            }
            if (!(height < heightMin)) continue;
            heightMin = height;
        }
        return new Vector3f(widthMax, heightMin, heightMax);
    }

    public void applyPosition(int xScale, int yScale) {
        this.pos.y += this.offsetY;
        this.pos.mul((float)xScale, (float)yScale);
        this.pos.sub((Vector2fc)this.root.planeAdvancements$getDefaultPos());
        this.root.planeAdvancements$setGridPos(this.pos);
    }

    public static List<AdvancementCluster> getGridClusters(AdvancementWidgetInterface root) {
        List<AdvancementCluster> clusters = root.planeAdvancements$getChildren().size() > 1 ? AdvancementCluster.getChildClusters(root) : AdvancementCluster.getSplitClusters(root);
        AdvancementCluster.calculateGrid(clusters);
        return clusters;
    }

    private static List<AdvancementCluster> getSplitClusters(AdvancementWidgetInterface root) {
        ArrayDeque<AdvancementWidgetInterface> queue = new ArrayDeque<AdvancementWidgetInterface>(root.planeAdvancements$getChildren());
        AdvancementWidgetInterface mostChildrenWidget = null;
        int mostChildrenCount = 2;
        while (!queue.isEmpty()) {
            AdvancementWidgetInterface widget = (AdvancementWidgetInterface)queue.remove();
            List<AdvancementWidgetInterface> children = widget.planeAdvancements$getChildren();
            queue.addAll(children);
            if (children.size() <= mostChildrenCount) continue;
            mostChildrenWidget = widget;
            mostChildrenCount = children.size();
        }
        if (mostChildrenWidget == null) {
            return AdvancementCluster.getChildClusters(root);
        }
        ArrayList<AdvancementCluster> clusters = new ArrayList<AdvancementCluster>();
        for (AdvancementWidgetInterface clusterRoot : mostChildrenWidget.planeAdvancements$getChildren()) {
            clusters.add(new AdvancementCluster(clusterRoot));
        }
        clusters.add(new AdvancementCluster(root.planeAdvancements$getChildren().getFirst(), mostChildrenWidget));
        clusters.add(new AdvancementCluster(root));
        return clusters;
    }

    private static List<AdvancementCluster> getChildClusters(AdvancementWidgetInterface root) {
        List<AdvancementWidgetInterface> clusterRoots = root.planeAdvancements$getChildren();
        ArrayList<AdvancementCluster> clusters = new ArrayList<AdvancementCluster>(clusterRoots.size());
        for (AdvancementWidgetInterface clusterRoot : clusterRoots) {
            clusters.add(new AdvancementCluster(clusterRoot));
        }
        clusters.add(new AdvancementCluster(root));
        return clusters;
    }

    private static void calculateGrid(List<AdvancementCluster> clusters) {
        AdvancementCluster root = clusters.removeLast();
        clusters.sort((a, b) -> {
            int i = Float.compare(b.size.y, a.size.y);
            return i == 0 ? Float.compare(b.size.x, a.size.x) : i;
        });
        int maxWidth = PlaneAdvancementsClient.gridWidth - 1;
        int usedWidth = 0;
        IntArrayList mask = new IntArrayList();
        block0: for (AdvancementCluster cluster : clusters) {
            int y = 0;
            int search = maxWidth - cluster.size.x + 1;
            if (search <= 1) {
                cluster.pos.x = 1.0f;
                cluster.pos.y = mask.size();
                for (int i = 0; i < cluster.size.y; ++i) {
                    mask.add(-1);
                }
                usedWidth = maxWidth;
                continue;
            }
            while (true) {
                int foundPosition;
                if ((foundPosition = AdvancementCluster.getFreePos(mask, cluster, search, y)) >= 0) {
                    int foundMask = AdvancementCluster.getMask(cluster.size.x, foundPosition);
                    for (int u = 0; u < cluster.size.y; ++u) {
                        int index = y + u;
                        if (index >= mask.size()) {
                            mask.add(foundMask);
                            continue;
                        }
                        mask.set(index, mask.getInt(index) | foundMask);
                    }
                    cluster.pos.x = foundPosition;
                    cluster.pos.y = y;
                    usedWidth = Math.max(usedWidth, foundPosition + cluster.size.x);
                    continue block0;
                }
                ++y;
            }
        }
        Vector2f mirror = new Vector2f((float)(usedWidth + 1), (float)mask.size());
        ArrayDeque<AdvancementCluster> toSettle = new ArrayDeque<AdvancementCluster>(clusters.reversed());
        while (!toSettle.isEmpty()) {
            int index;
            int u;
            int sizeMask;
            boolean hit;
            AdvancementCluster cluster = (AdvancementCluster)toSettle.remove();
            if (cluster.size.x >= maxWidth) {
                cluster.pos.y = mirror.y - cluster.pos.y - (float)cluster.size.y;
                continue;
            }
            int position = (int)cluster.pos.x;
            int y = (int)cluster.pos.y;
            int startingFilter = ~AdvancementCluster.getMask(cluster.size.x, position);
            block5: do {
                sizeMask = AdvancementCluster.getMask(cluster.size.x, ++position);
                if (cluster.size.x + position > usedWidth) {
                    hit = true;
                    continue;
                }
                hit = false;
                for (u = 0; u < cluster.size.y; ++u) {
                    index = y + u;
                    if ((mask.getInt(index) & startingFilter & sizeMask) == 0) continue;
                    hit = true;
                    continue block5;
                }
            } while (!hit);
            if ((float)(--position) == cluster.pos.x) {
                mirror.sub((Vector2fc)cluster.pos, cluster.pos).sub((float)cluster.size.x, (float)cluster.size.y);
                continue;
            }
            sizeMask = AdvancementCluster.getMask(cluster.size.x, position);
            for (u = 0; u < cluster.size.y; ++u) {
                index = y + u;
                mask.set(index, mask.getInt(index) & startingFilter | sizeMask);
            }
            cluster.pos.x = position;
            toSettle.add(cluster);
        }
        root.pos.x = 0.0f;
        root.pos.y = (float)(mask.size() - 1) / 2.0f;
        clusters.add(root);
    }

    private static int getFreePos(IntArrayList mask, AdvancementCluster cluster, int search, int y) {
        if (y >= mask.size()) {
            return 0;
        }
        int currentMask = mask.getInt(y);
        for (int i = 0; i < search; ++i) {
            int sizeMask = AdvancementCluster.getMask(cluster.size.x, i);
            if ((currentMask & sizeMask) != 0) continue;
            boolean found = true;
            for (int u = 0; u < cluster.size.y; ++u) {
                int index = y + u;
                if (index >= mask.size()) {
                    return i;
                }
                if ((mask.getInt(index) & sizeMask) == 0) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    private static int getMask(int size, int position) {
        return ((1 << size) - 1) * (1 << position);
    }

    public static void initialiseTree(AdvancementWidgetInterface root) {
        Vector2f rootPos = root.planeAdvancements$getTreePos();
        if (!Float.isNaN(rootPos.x) && !Float.isNaN(rootPos.y)) {
            for (AdvancementWidgetInterface child : root.planeAdvancements$getChildren()) {
                AdvancementCluster.initialiseTree(child);
            }
            return;
        }
        Stack<TreeNode> solve = new Stack<TreeNode>();
        float rootAngle = 0.0f;
        AdvancementWidgetInterface rootParent = root.planeAdvancements$getParent();
        if (rootParent != null) {
            AdvancementWidgetInterface validSibling = null;
            int validSiblings = 0;
            for (AdvancementWidgetInterface sibling : rootParent.planeAdvancements$getChildren()) {
                Vector2f siblingPos = sibling.planeAdvancements$getTreePos();
                if (Float.isNaN(siblingPos.x) || Float.isNaN(siblingPos.y)) continue;
                if (validSiblings == 0) {
                    validSibling = sibling;
                }
                ++validSiblings;
            }
            if (validSiblings == 0) {
                AdvancementWidgetInterface parentParent = rootParent.planeAdvancements$getParent();
                if (parentParent != null) {
                    Vector2f v = rootParent.planeAdvancements$getTreePos().sub((Vector2fc)parentParent.planeAdvancements$getTreePos(), new Vector2f());
                    rootAngle = (float)class_3532.method_15349((double)v.y, (double)v.x);
                } else {
                    rootAngle = 0.0f;
                }
            } else {
                if (++validSiblings % 2 == 0) {
                    validSiblings = -validSiblings;
                }
                Vector2f v = rootParent.planeAdvancements$getTreePos().sub((Vector2fc)validSibling.planeAdvancements$getTreePos(), new Vector2f());
                PlaneAdvancementsClient.LOGGER.info(validSiblings + " " + String.valueOf(v));
                rootAngle = (float)class_3532.method_15349((double)v.y, (double)v.x) + (float)Math.PI / (float)validSiblings;
            }
            root.planeAdvancements$getTreePos().set(class_3532.method_15362((float)rootAngle) * 64.0f, class_3532.method_15374((float)rootAngle) * 64.0f).add((Vector2fc)rootParent.planeAdvancements$getTreePos());
        } else {
            root.planeAdvancements$getTreePos().set(0.0f);
        }
        solve.push(new TreeNode(root, rootAngle));
        while (!solve.isEmpty()) {
            ((TreeNode)solve.pop()).arcChildren(solve);
        }
    }

    private record TreeNode(AdvancementWidgetInterface widget, float angle) {
        public void arcChildren(Stack<TreeNode> solve) {
            List<AdvancementWidgetInterface> children = this.widget.planeAdvancements$getChildren();
            for (int i = 0; i < children.size(); ++i) {
                AdvancementWidgetInterface child = children.get(i);
                float t = this.widget.planeAdvancements$getParent() == null ? (float)Math.PI * 2 * (float)i / (float)children.size() : (children.size() > 1 ? this.angle + 1.5707964f * ((float)i / ((float)children.size() - 1.0f) - 0.5f) : this.angle);
                child.planeAdvancements$getTreePos().set(class_3532.method_15362((float)t) * 64.0f, class_3532.method_15374((float)t) * 64.0f).add((Vector2fc)this.widget.planeAdvancements$getTreePos());
                solve.push(new TreeNode(child, t));
            }
        }
    }
}

