/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.planeadvancements;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.nettakrim.planeadvancements.AdvancementWidgetInterface;
import com.nettakrim.planeadvancements.CallableSlider;
import com.nettakrim.planeadvancements.LineType;
import com.nettakrim.planeadvancements.TreePosition;
import com.nettakrim.planeadvancements.TreeType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_12079;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_7403;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaneAdvancementsClient
implements ClientModInitializer {
    public static final String MOD_ID = "planeadvancements";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"planeadvancements");
    private static Path configDir;
    public static TreeType treeType;
    public static float repulsion;
    public static boolean angledLines;
    public static int gridWidth;
    public static boolean merged;
    public static AdvancementWidgetInterface draggedWidget;
    public static class_4185 treeButton;
    public static class_4185 lineButton;
    public static class_357 repulsionSlider;
    public static class_357 gridWidthSlider;
    public static class_4185 mergedButton;
    public static final Map<class_161, TreePosition> positions;
    public static final class_185 mergedDisplay;
    public static final class_161 mergedAdvancement;
    public static final class_8779 mergedEntry;
    public static boolean mergedTreeNeedsUpdate;
    private static final Codec<Data> dataCodec;

    public void onInitializeClient() {
        PlaneAdvancementsClient.loadConfig();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> PlaneAdvancementsClient.saveConfig());
        treeButton = class_4185.method_46430((class_2561)PlaneAdvancementsClient.getTreeText(), w -> PlaneAdvancementsClient.cycleTreeType()).method_46434(0, 0, 16, 16).method_46431();
        lineButton = class_4185.method_46430((class_2561)PlaneAdvancementsClient.getLineText(), w -> PlaneAdvancementsClient.cycleLineType()).method_46434(80, 0, 16, 16).method_46431();
        repulsionSlider = new CallableSlider(16, 0, 64, 16, PlaneAdvancementsClient::getRepulsionText, class_3532.method_15355((float)repulsion), v -> {
            repulsion = Math.max((float)(v * v), 0.01f);
        });
        gridWidthSlider = new CallableSlider(16, 0, 64, 16, PlaneAdvancementsClient::getGridWidthText, (double)(gridWidth - 2) / 14.0, v -> {
            gridWidth = (int)Math.round(v * 14.0 + 2.0);
        });
        mergedButton = class_4185.method_46430((class_2561)PlaneAdvancementsClient.getMergedText(), w -> PlaneAdvancementsClient.cycleMerged()).method_46434(96, 0, 16, 16).method_46431();
        PlaneAdvancementsClient.setUIActive();
    }

    private static class_2561 getTreeText() {
        return class_2561.method_43471((String)("planeadvancements.tree." + treeType.name().toLowerCase(Locale.ROOT)));
    }

    private static class_2561 getLineText() {
        return class_2561.method_43471((String)("planeadvancements.line." + (angledLines ? "rotated" : "smart")));
    }

    private static class_2561 getRepulsionText() {
        return class_2561.method_43469((String)"planeadvancements.repulsion", (Object[])new Object[]{repulsion <= 0.01f ? "0.0" : String.valueOf(class_3532.method_15355((float)repulsion) + 0.01f).substring(0, 3)});
    }

    private static class_2561 getGridWidthText() {
        return class_2561.method_43469((String)"planeadvancements.grid_width", (Object[])new Object[]{gridWidth});
    }

    private static class_2561 getMergedText() {
        return class_2561.method_43471((String)(MOD_ID + (merged ? ".merged" : ".unmerged")));
    }

    public static LineType getCurrentLineType() {
        return treeType == TreeType.SPRING ? (angledLines ? LineType.ROTATED : LineType.SMART) : LineType.DEFAULT;
    }

    public static void cycleTreeType() {
        treeType = TreeType.values()[(treeType.ordinal() + 1) % TreeType.values().length];
        treeButton.method_25355(PlaneAdvancementsClient.getTreeText());
        PlaneAdvancementsClient.setUIActive();
    }

    public static void cycleLineType() {
        angledLines = !angledLines;
        lineButton.method_25355(PlaneAdvancementsClient.getLineText());
    }

    public static void cycleMerged() {
        merged = !merged;
        mergedButton.method_25355(PlaneAdvancementsClient.getMergedText());
    }

    public static boolean hoveredUI() {
        return treeButton.method_49606() || lineButton.method_49606() || repulsionSlider.method_49606() || gridWidthSlider.method_49606() || mergedButton.method_49606();
    }

    public static boolean selectedUI() {
        return treeButton.method_25370() || lineButton.method_25370() || repulsionSlider.method_25370() || gridWidthSlider.method_25370() || mergedButton.method_25370();
    }

    public static void clearUIHover() {
        treeButton.method_25365(false);
        lineButton.method_25365(false);
        repulsionSlider.method_25365(false);
        gridWidthSlider.method_25365(false);
        mergedButton.method_25365(false);
    }

    public static void renderUI(class_332 context, int mouseX, int mouseY, float tickDelta) {
        treeButton.method_25394(context, mouseX, mouseY, tickDelta);
        if (treeType == TreeType.SPRING) {
            lineButton.method_25394(context, mouseX, mouseY, tickDelta);
            repulsionSlider.method_25394(context, mouseX, mouseY, tickDelta);
            mergedButton.method_25394(context, mouseX, mouseY, tickDelta);
        }
        if (treeType == TreeType.GRID) {
            gridWidthSlider.method_25394(context, mouseX, mouseY, tickDelta);
        }
    }

    private static void setUIActive() {
        boolean isTree;
        PlaneAdvancementsClient.lineButton.field_22763 = isTree = treeType == TreeType.SPRING;
        PlaneAdvancementsClient.repulsionSlider.field_22763 = isTree;
        PlaneAdvancementsClient.mergedButton.field_22763 = isTree;
        PlaneAdvancementsClient.gridWidthSlider.field_22763 = treeType == TreeType.GRID;
    }

    public static boolean isMergedAndSpring() {
        return merged && treeType == TreeType.SPRING;
    }

    public static int getTemperature() {
        return merged && treeType == TreeType.SPRING ? 1500 : 1000;
    }

    private static void loadConfig() {
        configDir = FabricLoader.getInstance().getConfigDir().resolve("planeadvancements.json");
        if (!configDir.toFile().exists()) {
            PlaneAdvancementsClient.saveConfig();
            return;
        }
        try {
            Data data = dataCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)new GsonBuilder().create().fromJson((Reader)Files.newBufferedReader(configDir), JsonElement.class))).result().orElse(new Data(treeType.ordinal(), 0.1f, true, 10, false));
            treeType = TreeType.values()[data.treeType];
            repulsion = data.repulsion;
            angledLines = data.angledLines;
            gridWidth = data.gridWidth;
            merged = data.merged;
        }
        catch (IOException e) {
            LOGGER.info("Failed to load file from {} {}", (Object)configDir, (Object)e);
        }
    }

    private static void saveConfig() {
        CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8));){
                    jsonWriter.setSerializeNulls(false);
                    jsonWriter.setIndent("");
                    class_3518.method_43677((JsonWriter)jsonWriter, (JsonElement)((JsonElement)dataCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new Data(treeType.ordinal(), repulsion, angledLines, gridWidth, merged)).getOrThrow()), (Comparator)class_2405.field_39213);
                }
                class_7403.field_39439.method_43346(configDir, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
            }
            catch (IOException e) {
                LOGGER.info("Failed to save file to {} {}", (Object)configDir, (Object)e);
            }
        }, class_156.method_18349().method_64116("saveStable"));
    }

    static {
        treeType = TreeType.SPRING;
        repulsion = 0.1f;
        angledLines = true;
        gridWidth = 10;
        merged = false;
        positions = new HashMap<class_161, TreePosition>();
        mergedDisplay = new class_185(class_1799.field_8037, (class_2561)class_2561.method_43471((String)"planeadvancements.merged_title"), (class_2561)class_2561.method_43471((String)"planeadvancements.merged_description"), Optional.of(new class_12079.class_10726(class_2960.method_60655((String)MOD_ID, (String)"merged_background"))), class_189.field_1250, false, false, false);
        mergedAdvancement = new class_161(Optional.empty(), Optional.of(mergedDisplay), class_170.field_1167, Map.of(), class_8782.field_46084, false);
        mergedEntry = new class_8779(class_2960.method_60655((String)MOD_ID, (String)"merged"), mergedAdvancement);
        dataCodec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("treeType", (Object)1).forGetter(Data::treeType), (App)Codec.FLOAT.optionalFieldOf("repulsion", (Object)Float.valueOf(0.1f)).forGetter(Data::repulsion), (App)Codec.BOOL.optionalFieldOf("angledLines", (Object)true).forGetter(Data::angledLines), (App)Codec.INT.optionalFieldOf("gridWidth", (Object)10).forGetter(Data::gridWidth), (App)Codec.BOOL.optionalFieldOf("merged", (Object)false).forGetter(Data::merged)).apply((Applicative)instance, Data::new));
    }

    private record Data(int treeType, float repulsion, boolean angledLines, int gridWidth, boolean merged) {
    }
}

