/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.planeadvancements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.nettakrim.planeadvancements.AdvancementCluster;
import com.nettakrim.planeadvancements.AdvancementTabInterface;
import com.nettakrim.planeadvancements.AdvancementWidgetInterface;
import com.nettakrim.planeadvancements.PlaneAdvancementsClient;
import com.nettakrim.planeadvancements.TreeType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"betteradvancements.common.gui.BetterAdvancementTab"}, remap=false)
public abstract class BetterAdvancementTabMixin
implements AdvancementTabInterface {
    @Shadow
    @Final
    @Mutable
    private Map<class_8779, AdvancementWidgetInterface> widgets;
    @Shadow
    private int minX;
    @Shadow
    private int maxX;
    @Shadow
    private int minY;
    @Shadow
    private int maxY;
    @Shadow
    private int scrollX;
    @Shadow
    private int scrollY;
    @Unique
    private AdvancementWidgetInterface root;
    @Shadow
    @Final
    @Mutable
    private class_8781 rootNode;
    @Shadow
    @Final
    @Mutable
    private class_185 display;
    @Unique
    private int temperature = -1;
    @Unique
    private TreeType currentType = TreeType.DEFAULT;
    @Unique
    private float currentRepulsion = PlaneAdvancementsClient.repulsion;
    @Unique
    private int currentGridWidth;
    @Unique
    private boolean treeNeedsUpdate;
    @Unique
    private AdvancementWidgetInterface rootBackup = null;
    @Unique
    private Map<class_8779, AdvancementWidgetInterface> widgetsBackup = null;

    @Inject(at={@At(value="TAIL")}, method={"<init>"}, remap=true)
    private void init(class_310 client, @Coerce Object screen, @Coerce Object type, int index, class_8781 root, class_185 display, CallbackInfo ci) {
        try {
            this.root = (AdvancementWidgetInterface)this.getClass().getDeclaredField("root").get(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"drawContents"}, remap=true)
    private void render(class_332 context, int left, int top, int width, int height, float zoom, CallbackInfo ci) {
        if (this.temperature == -1) {
            this.planeAdvancements$heatGraph();
            this.planeAdvancements$centerPan(width, height);
        }
        if (PlaneAdvancementsClient.isMergedAndSpring()) {
            if (PlaneAdvancementsClient.mergedTreeNeedsUpdate) {
                AdvancementCluster.initialiseTree(this.planeAdvancements$getRoot());
                PlaneAdvancementsClient.mergedTreeNeedsUpdate = false;
            }
        } else if (this.treeNeedsUpdate) {
            AdvancementCluster.initialiseTree(this.planeAdvancements$getRoot());
            this.treeNeedsUpdate = false;
        }
        if (this.currentGridWidth != PlaneAdvancementsClient.gridWidth && PlaneAdvancementsClient.treeType == TreeType.GRID) {
            this.planeAdvancements$applyClusters(AdvancementCluster.getGridClusters(this.planeAdvancements$getRoot()));
            this.planeAdvancements$updateRange(width, height);
            this.planeAdvancements$centerPan(width, height);
            this.currentGridWidth = PlaneAdvancementsClient.gridWidth;
        }
        if (this.currentType != PlaneAdvancementsClient.treeType) {
            this.planeAdvancements$updateRange(width, height);
            this.planeAdvancements$centerPan(width, height);
        }
        if (this.currentRepulsion != PlaneAdvancementsClient.repulsion) {
            this.currentRepulsion = PlaneAdvancementsClient.repulsion;
            this.planeAdvancements$heatGraph();
        }
        if (this.temperature <= 0) {
            return;
        }
        --this.temperature;
        int steps = class_3532.method_15386((float)class_3532.method_15355((float)((float)this.temperature / 10.0f)));
        for (int i = 0; i < steps; ++i) {
            for (AdvancementWidgetInterface widgetA : this.widgets.values()) {
                for (AdvancementWidgetInterface widgetB : this.widgets.values()) {
                    widgetA.planeAdvancements$applySpringForce(widgetB, 0.1f, PlaneAdvancementsClient.repulsion);
                }
            }
        }
        if (PlaneAdvancementsClient.treeType == TreeType.SPRING) {
            if (this.temperature % 60 == 1) {
                this.planeAdvancements$updateRange(width, height);
            } else {
                for (AdvancementWidgetInterface widget : this.widgets.values()) {
                    widget.planeAdvancements$updatePos();
                }
            }
        }
    }

    @ModifyReceiver(at={@At(value="INVOKE", target="Lbetteradvancements/common/gui/BetterAdvancementWidget;drawConnectivity(Lnet/minecraft/client/gui/DrawContext;IIZ)V")}, method={"drawContents"}, remap=true)
    @Coerce
    private AdvancementWidgetInterface replaceLineDrawer(@Coerce AdvancementWidgetInterface receiver, class_332 context, int x, int y, boolean border) {
        return this.root;
    }

    @ModifyReceiver(at={@At(value="INVOKE", target="Lbetteradvancements/common/gui/BetterAdvancementWidget;draw(Lnet/minecraft/client/gui/DrawContext;II)V")}, method={"drawContents"}, remap=true)
    @Coerce
    private AdvancementWidgetInterface replaceWidgetDrawer(@Coerce AdvancementWidgetInterface receiver, class_332 context, int x, int y) {
        return this.root;
    }

    @Inject(at={@At(value="TAIL")}, method={"scroll"}, remap=true)
    private void fixPan(double x, double y, int width, int height, CallbackInfo ci) {
        if (PlaneAdvancementsClient.treeType != TreeType.SPRING) {
            return;
        }
        if (this.maxX - this.minX <= width) {
            this.scrollX = (width - (this.maxX + this.minX)) / 2;
        }
        if (this.maxY - this.minY <= height) {
            this.scrollY = (height - (this.maxY + this.minY)) / 2;
        }
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getTitle"}, remap=true)
    private class_2561 setTitle(class_2561 original) {
        if (PlaneAdvancementsClient.isMergedAndSpring()) {
            return class_2561.method_43471((String)"planeadvancements.merged_tab_better");
        }
        return original;
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"isMouseOver"}, remap=true)
    private boolean hideTab(boolean original) {
        return original && !PlaneAdvancementsClient.isMergedAndSpring();
    }

    @Inject(at={@At(value="TAIL")}, method={"addWidget"}, remap=true)
    private void widgetAdded(CallbackInfo callbackInfo) {
        this.treeNeedsUpdate = true;
        PlaneAdvancementsClient.mergedTreeNeedsUpdate = true;
    }

    @Override
    public void planeAdvancements$heatGraph() {
        this.temperature = PlaneAdvancementsClient.getTemperature();
    }

    @Override
    public Map<class_8779, AdvancementWidgetInterface> planeAdvancements$getWidgets() {
        return this.widgets;
    }

    @Override
    public AdvancementWidgetInterface planeAdvancements$getRoot() {
        return this.root;
    }

    @Override
    public double planeAdvancements$getPanX() {
        return this.scrollX;
    }

    @Override
    public double planeAdvancements$getPanY() {
        return this.scrollY;
    }

    @Override
    public void planeAdvancements$updateRange(int width, int height) {
        this.currentType = PlaneAdvancementsClient.treeType;
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        for (AdvancementWidgetInterface widget : this.widgets.values()) {
            widget.planeAdvancements$updatePos();
            int i = widget.planeAdvancements$getX();
            int j = i + 28;
            int k = widget.planeAdvancements$getY();
            int l = k + 27;
            this.minX = Math.min(this.minX, i);
            this.maxX = Math.max(this.maxX, j);
            this.minY = Math.min(this.minY, k);
            this.maxY = Math.max(this.maxY, l);
        }
        if (PlaneAdvancementsClient.treeType == TreeType.SPRING) {
            this.minX -= width / 2;
            this.maxX += width / 2;
            this.minY -= height / 2;
            this.maxY += height / 2;
        } else if (this.maxX - this.minX > width) {
            this.maxX += 4;
        }
    }

    @Override
    public void planeAdvancements$centerPan(int width, int height) {
        this.scrollX = (width - (this.maxX + this.minX)) / 2;
        this.scrollY = (height - (this.maxY + this.minY)) / 2;
    }

    @Override
    public void planeAdvancements$applyClusters(List<AdvancementCluster> clusters) {
        for (AdvancementCluster cluster : clusters) {
            cluster.applyPosition(32, 27);
        }
    }

    @Override
    public void planeAdvancements$setMerged(Collection<AdvancementTabInterface> tabs) {
        AdvancementWidgetInterface newRootInterface;
        if (this.widgetsBackup != null) {
            return;
        }
        this.widgetsBackup = this.widgets;
        this.widgets = new HashMap<class_8779, AdvancementWidgetInterface>(this.widgetsBackup);
        class_8781 placedAdvancement = new class_8781(PlaneAdvancementsClient.mergedEntry, null);
        try {
            newRootInterface = (AdvancementWidgetInterface)this.root.getClass().getConstructors()[0].newInstance(this, class_310.method_1551(), placedAdvancement, PlaneAdvancementsClient.mergedDisplay);
        }
        catch (Exception ignored) {
            return;
        }
        tabs.forEach(tab -> {
            AdvancementWidgetInterface tabRoot = tab.planeAdvancements$getRoot();
            tabRoot.planeAdvancements$setParent(newRootInterface);
            newRootInterface.planeAdvancements$getChildren().add(tabRoot);
            this.widgets.putAll(tab.planeAdvancements$getWidgets());
        });
        this.widgets.put(PlaneAdvancementsClient.mergedEntry, newRootInterface);
        this.rootBackup = this.root;
        this.root = newRootInterface;
        this.display = PlaneAdvancementsClient.mergedDisplay;
        this.rootNode = placedAdvancement;
        this.planeAdvancements$heatGraph();
        this.currentType = TreeType.DEFAULT;
    }

    @Override
    public void planeAdvancements$clearMerged(Collection<AdvancementTabInterface> tabs) {
        if (this.widgetsBackup == null) {
            return;
        }
        this.widgets = this.widgetsBackup;
        this.widgetsBackup = null;
        this.root = this.rootBackup;
        this.display = this.root.planeAdvancements$getDisplay();
        this.rootNode = this.root.planeAdvancements$getPlaced();
        tabs.forEach(tab -> {
            AdvancementWidgetInterface tabRoot = tab.planeAdvancements$getRoot();
            tabRoot.planeAdvancements$setParent(null);
            ((BetterAdvancementTabMixin)tab).currentType = TreeType.SPRING;
        });
        this.planeAdvancements$heatGraph();
        this.currentType = TreeType.DEFAULT;
    }
}

