/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights;

import com.mojang.brigadier.arguments.StringArgumentType;
import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.addons.AddonManager;
import dev.frankheijden.insights.api.concurrent.ChunkContainerExecutor;
import dev.frankheijden.insights.api.concurrent.ChunkTeleport;
import dev.frankheijden.insights.api.concurrent.PlayerList;
import dev.frankheijden.insights.api.concurrent.count.RedstoneUpdateCount;
import dev.frankheijden.insights.api.concurrent.storage.AddonStorage;
import dev.frankheijden.insights.api.concurrent.storage.ScanHistory;
import dev.frankheijden.insights.api.concurrent.storage.WorldStorage;
import dev.frankheijden.insights.api.concurrent.tracker.AddonScanTracker;
import dev.frankheijden.insights.api.concurrent.tracker.WorldChunkScanTracker;
import dev.frankheijden.insights.api.config.Limits;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.Notifications;
import dev.frankheijden.insights.api.config.Settings;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.config.parser.YamlParseException;
import dev.frankheijden.insights.api.metrics.MetricsManager;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.tasks.UpdateCheckerTask;
import dev.frankheijden.insights.api.utils.IOUtils;
import dev.frankheijden.insights.commands.CommandCancelScan;
import dev.frankheijden.insights.commands.CommandInsights;
import dev.frankheijden.insights.commands.CommandScan;
import dev.frankheijden.insights.commands.CommandScanCache;
import dev.frankheijden.insights.commands.CommandScanHistory;
import dev.frankheijden.insights.commands.CommandScanRegion;
import dev.frankheijden.insights.commands.CommandScanWorld;
import dev.frankheijden.insights.commands.CommandTeleportChunk;
import dev.frankheijden.insights.commands.parser.LimitParser;
import dev.frankheijden.insights.commands.parser.ScanHistoryPageParser;
import dev.frankheijden.insights.commands.parser.ScanObjectArrayParser;
import dev.frankheijden.insights.commands.parser.WorldParser;
import dev.frankheijden.insights.commands.util.CommandSenderMapper;
import dev.frankheijden.insights.concurrent.ContainerExecutorService;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.AnnotationParser;
import dev.frankheijden.insights.core.dependencies.cloud.execution.ExecutionCoordinator;
import dev.frankheijden.insights.core.dependencies.cloud.paper.PaperCommandManager;
import dev.frankheijden.insights.core.dependencies.cloud.parser.ParserRegistry;
import dev.frankheijden.insights.core.dependencies.semver.Version;
import dev.frankheijden.insights.core.dependencies.typetoken.TypeToken;
import dev.frankheijden.insights.dependencies.adventure.platform.bukkit.BukkitAudiences;
import dev.frankheijden.insights.dependencies.paperlib.PaperLib;
import dev.frankheijden.insights.listeners.manager.ListenerManager;
import dev.frankheijden.insights.nms.core.InsightsNMS;
import dev.frankheijden.insights.placeholders.InsightsPlaceholderExpansion;
import dev.frankheijden.insights.tasks.PlayerTrackerTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Insights
extends InsightsPlugin {
    private static final Version minimumCompatibleVersion = Version.of(1L, 21L, 5L);
    private static final String SETTINGS_FILE_NAME = "config.yml";
    private static final String MESSAGES_FILE_NAME = "messages.yml";
    private static final String LIMITS_FOLDER_NAME = "limits";
    private Settings settings;
    private Messages messages = null;
    private Notifications notifications;
    private Limits limits;
    private AddonManager addonManager;
    private ContainerExecutorService executor;
    private ChunkContainerExecutor chunkContainerExecutor;
    private PlayerList playerList;
    private WorldStorage worldStorage;
    private AddonStorage addonStorage;
    private WorldChunkScanTracker worldChunkScanTracker;
    private AddonScanTracker addonScanTracker;
    private MetricsManager metricsManager;
    private ScanHistory scanHistory;
    private ListenerManager listenerManager;
    private InsightsPlaceholderExpansion placeholderExpansion;
    private BukkitTask playerTracker = null;
    private BukkitTask updateChecker = null;
    private BukkitAudiences audiences = null;
    private RedstoneUpdateCount redstoneUpdateCount = null;
    private ChunkTeleport chunkTeleport;
    private InsightsNMS nms;

    public void onLoad() {
        super.onLoad();
        instance = this;
    }

    public void onEnable() {
        super.onEnable();
        if (Insights.isIncompatible()) {
            throw new RuntimeException("Insights is incompatible with your server version, we require a Paper backend and a Minecraft version of at least " + String.valueOf(minimumCompatibleVersion));
        }
        this.nms = InsightsNMS.get();
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.listenerManager = new ListenerManager(this);
        this.reloadConfigs();
        this.addonManager = new AddonManager(this, this.getDataFolder().toPath().resolve("addons"));
        try {
            this.addonManager.createAddonsFolder();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            try {
                this.addonManager.loadAddons();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }, 1L);
        this.playerList = new PlayerList(Bukkit.getOnlinePlayers());
        this.worldStorage = new WorldStorage();
        this.addonStorage = new AddonStorage();
        this.worldChunkScanTracker = new WorldChunkScanTracker();
        this.addonScanTracker = new AddonScanTracker();
        this.executor = ContainerExecutorService.newExecutor(this.settings.SCANS_CONCURRENT_THREADS, this.settings.SCANS_TIMEOUT_MILLIS);
        this.chunkContainerExecutor = new ChunkContainerExecutor(this.nms, this.executor, this.worldStorage, this.worldChunkScanTracker);
        this.metricsManager = new MetricsManager(this);
        this.scanHistory = new ScanHistory();
        this.redstoneUpdateCount = new RedstoneUpdateCount(this);
        this.redstoneUpdateCount.start();
        this.chunkTeleport = new ChunkTeleport(this);
        this.loadCommands();
        this.reload();
    }

    private static boolean isIncompatible() {
        Version minecraftVersion = Version.parse(Bukkit.getServer().getMinecraftVersion(), false);
        return !PaperLib.isPaper() || minecraftVersion.compareTo(minimumCompatibleVersion) < 0;
    }

    public void onDisable() {
        if (Insights.isIncompatible()) {
            return;
        }
        this.listenerManager.unregister();
        this.redstoneUpdateCount.stop();
        this.notifications.clearNotifications();
        if (this.placeholderExpansion != null) {
            this.placeholderExpansion.unregister();
            this.placeholderExpansion = null;
        }
        this.chunkContainerExecutor.shutdown();
        this.audiences.close();
    }

    @Override
    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    @Override
    public RedstoneUpdateCount getRedstoneUpdateCount() {
        return this.redstoneUpdateCount;
    }

    @Override
    public ChunkTeleport getChunkTeleport() {
        return this.chunkTeleport;
    }

    @Override
    public InsightsNMS getNMS() {
        return this.nms;
    }

    @Override
    public void reloadSettings() {
        File file = new File(this.getDataFolder(), SETTINGS_FILE_NAME);
        try {
            this.settings = Settings.load(this, file, this.getResource(SETTINGS_FILE_NAME)).exceptionally(this.getLogger());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void reloadMessages() {
        File file = new File(this.getDataFolder(), MESSAGES_FILE_NAME);
        try {
            this.messages = Messages.load(this, this.audiences, file, this.getResource(MESSAGES_FILE_NAME));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void reloadNotifications() {
        if (this.settings == null || this.messages == null) {
            throw new IllegalArgumentException("Settings or Messages not initialised!");
        }
        this.notifications = new Notifications(this);
    }

    @Override
    public void reloadLimits() {
        this.limits = new Limits();
        Path limitsPath = this.getDataFolder().toPath().resolve(LIMITS_FOLDER_NAME);
        if (!Files.exists(limitsPath, new LinkOption[0])) {
            try {
                Files.createDirectory(limitsPath, new FileAttribute[0]);
                IOUtils.copyResources(limitsPath, this.getClassLoader(), Arrays.asList("bed-limit.yml", "redstone-limit.yml", "tile-limit.yml"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(limitsPath, p -> !Files.isDirectory(p, new LinkOption[0]));){
            for (Path child : stream) {
                String fileName = child.getFileName().toString();
                if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".yml")) continue;
                try {
                    Limit limit = Limit.parse(child.toFile());
                    this.getLogger().info("Loaded limit '" + fileName + "'");
                    this.limits.addLimit(limit);
                }
                catch (YamlParseException ex) {
                    this.getLogger().severe("Limit '" + fileName + "' could not be loaded:");
                    this.getLogger().severe(ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadCommands() {
        PaperCommandManager<CommandSender> commandManager = PaperCommandManager.builder(new CommandSenderMapper()).executionCoordinator(ExecutionCoordinator.asyncCoordinator()).buildOnEnable((Plugin)this);
        ParserRegistry parserRegistry = commandManager.parserRegistry();
        parserRegistry.registerParserSupplier(TypeToken.get(new TypeToken<Limit>(this){}.getType()), LimitParser::new);
        parserRegistry.registerParserSupplier(TypeToken.get(new TypeToken<ScanObject<?>[]>(this){}.getType()), ScanObjectArrayParser::new);
        parserRegistry.registerParserSupplier(TypeToken.get(new TypeToken<CommandScanHistory.Page>(this){}.getType()), ScanHistoryPageParser::new);
        parserRegistry.registerParserSupplier(TypeToken.get(new TypeToken<World>(this){}.getType()), WorldParser::new);
        if (commandManager.hasBrigadierManager()) {
            commandManager.brigadierManager().registerMapping(new TypeToken<ScanObjectArrayParser<CommandSender>>(this){}, builder -> {
                builder.to(argument -> StringArgumentType.greedyString());
                builder.cloudSuggestions();
            });
        }
        AnnotationParser<CommandSender> annotationParser = new AnnotationParser<CommandSender>(commandManager, CommandSender.class);
        annotationParser.parse(new CommandInsights(this));
        annotationParser.parse(new CommandScan(this));
        annotationParser.parse(new CommandScanCache(this));
        annotationParser.parse(new CommandScanWorld(this));
        annotationParser.parse(new CommandScanRegion(this));
        annotationParser.parse(new CommandScanHistory(this));
        annotationParser.parse(new CommandTeleportChunk(this));
        annotationParser.parse(new CommandCancelScan(this));
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public Limits getLimits() {
        return this.limits;
    }

    @Override
    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    @Override
    public Notifications getNotifications() {
        return this.notifications;
    }

    @Override
    public ContainerExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public ChunkContainerExecutor getChunkContainerExecutor() {
        return this.chunkContainerExecutor;
    }

    @Override
    public PlayerList getPlayerList() {
        return this.playerList;
    }

    @Override
    public WorldStorage getWorldStorage() {
        return this.worldStorage;
    }

    @Override
    public AddonStorage getAddonStorage() {
        return this.addonStorage;
    }

    @Override
    public WorldChunkScanTracker getWorldChunkScanTracker() {
        return this.worldChunkScanTracker;
    }

    @Override
    public AddonScanTracker getAddonScanTracker() {
        return this.addonScanTracker;
    }

    @Override
    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }

    @Override
    public ScanHistory getScanHistory() {
        return this.scanHistory;
    }

    @Override
    public void reload() {
        if (this.playerTracker != null) {
            this.playerTracker.cancel();
        }
        if (this.settings.CHUNK_SCANS_MODE == Settings.ChunkScanMode.ALWAYS) {
            this.playerTracker = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new PlayerTrackerTask(this), 0L, (long)this.settings.CHUNK_SCANS_PLAYER_TRACKER_INTERVAL_TICKS);
        }
        if (this.updateChecker != null) {
            this.updateChecker.cancel();
        }
        if (this.settings.UPDATE_CHECKER_ENABLED) {
            this.updateChecker = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new UpdateCheckerTask(this), 20L, 20L * (long)this.settings.UPDATE_CHECKER_INTERVAL_SECONDS);
        }
        this.listenerManager.unregister();
        this.listenerManager.register();
        if (this.placeholderExpansion == null && this.isAvailable("PlaceholderAPI")) {
            this.placeholderExpansion = new InsightsPlaceholderExpansion(this);
            this.placeholderExpansion.register();
        }
    }
}

