/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.addons;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.addons.AddonException;
import dev.frankheijden.insights.api.addons.InsightsAddon;
import dev.frankheijden.insights.api.addons.Region;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class AddonManager {
    private static final DirectoryStream.Filter<Path> addonsFilter = path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar");
    private final InsightsPlugin plugin;
    private final Path addonsFolder;
    private final Map<String, InsightsAddon> addons;

    public AddonManager(InsightsPlugin plugin, Path addonsFolder) {
        this.plugin = plugin;
        this.addonsFolder = addonsFolder;
        this.addons = new HashMap<String, InsightsAddon>();
    }

    public void createAddonsFolder() throws IOException {
        if (!Files.isDirectory(this.addonsFolder, new LinkOption[0])) {
            Files.createDirectory(this.addonsFolder, new FileAttribute[0]);
        }
    }

    public void loadAddons() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.addonsFolder, addonsFilter);){
            for (Path path : stream) {
                InsightsAddon addon;
                try {
                    addon = this.loadAddon(path);
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, ex, () -> "Error loading addon '" + path.getFileName().toString() + "'");
                    continue;
                }
                if (!InsightsPlugin.getInstance().isAvailable(addon.getPluginName())) {
                    this.plugin.getLogger().severe("Error loading addon: " + addon.getPluginName() + " is not enabled!");
                    continue;
                }
                if (addon instanceof Listener) {
                    Bukkit.getPluginManager().registerEvents((Listener)addon, (Plugin)this.plugin);
                    this.plugin.getLogger().info("Registered listener of addon '" + addon.getPluginName() + "'");
                }
                this.addons.put(addon.getPluginName(), addon);
                this.plugin.getLogger().info("Loaded addon '" + addon.getPluginName() + "' v" + addon.getVersion());
            }
        }
    }

    public InsightsAddon loadAddon(Path path) throws AddonException, MalformedURLException {
        return this.loadAddon(path.toUri().toURL());
    }

    public InsightsAddon loadAddon(URL url) throws AddonException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InsightsAddon addon = null;
        try (URLClassLoader loader = new URLClassLoader(new URL[]{url}, classLoader);
             JarInputStream in = new JarInputStream(url.openStream());){
            JarEntry entry = in.getNextJarEntry();
            while (entry != null) {
                String className;
                Class<?> clazz;
                String name = entry.getName();
                if (name.endsWith(".class") && InsightsAddon.class.isAssignableFrom(clazz = loader.loadClass(className = (name = name.replace("/", ".")).substring(0, name.lastIndexOf(".class"))))) {
                    addon = this.newAddonInstance(clazz);
                }
                entry = in.getNextJarEntry();
            }
        }
        catch (Exception ex) {
            throw new AddonException(ex);
        }
        if (addon == null) {
            throw new AddonException("No main class found.");
        }
        return addon;
    }

    private InsightsAddon newAddonInstance(Class<?> clazz) throws AddonException {
        Constructor<?>[] constructors;
        try {
            constructors = clazz.getConstructors();
        }
        catch (Exception ex) {
            throw new AddonException(ex);
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            try {
                return (InsightsAddon)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new AddonException(ex);
            }
        }
        throw new AddonException("'" + clazz.getName() + "' does not have a default constructor!");
    }

    public InsightsAddon getAddon(String pluginName) {
        return this.addons.get(pluginName);
    }

    public Optional<Region> getRegion(Location location) {
        ArrayList<String> addonsToRemove = new ArrayList<String>();
        Optional<Region> regionOptional = Optional.empty();
        for (InsightsAddon addon : this.addons.values()) {
            String pluginName = addon.getPluginName();
            if (!this.plugin.isAvailable(pluginName)) {
                addonsToRemove.add(addon.getPluginName());
                continue;
            }
            regionOptional = addon.getRegion(location);
            if (!regionOptional.isPresent()) continue;
            break;
        }
        for (String pluginName : addonsToRemove) {
            InsightsAddon addon = this.addons.remove(pluginName);
            if (addon == null) continue;
            this.plugin.getLogger().warning("Unloaded addon '" + addon.getPluginName() + "' v" + addon.getVersion() + ", because the plugin disappeared.");
        }
        return regionOptional;
    }
}

