/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.concurrent.ContainerExecutor;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.concurrent.containers.ChunkContainer;
import dev.frankheijden.insights.api.concurrent.containers.LoadedChunkContainer;
import dev.frankheijden.insights.api.concurrent.containers.RunnableContainer;
import dev.frankheijden.insights.api.concurrent.containers.SupplierContainer;
import dev.frankheijden.insights.api.concurrent.containers.UnloadedChunkContainer;
import dev.frankheijden.insights.api.concurrent.storage.Storage;
import dev.frankheijden.insights.api.concurrent.storage.WorldStorage;
import dev.frankheijden.insights.api.concurrent.tracker.WorldChunkScanTracker;
import dev.frankheijden.insights.api.exceptions.ChunkCuboidOutOfBoundsException;
import dev.frankheijden.insights.api.metrics.MetricsManager;
import dev.frankheijden.insights.api.objects.chunk.ChunkCuboid;
import dev.frankheijden.insights.nms.core.InsightsNMS;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.World;

public class ChunkContainerExecutor
implements ContainerExecutor {
    private final InsightsNMS nms;
    private final ContainerExecutor containerExecutor;
    private final WorldStorage worldStorage;
    private final WorldChunkScanTracker scanTracker;

    public ChunkContainerExecutor(InsightsNMS nms, ContainerExecutor containerExecutor, WorldStorage worldStorage, WorldChunkScanTracker scanTracker) {
        this.nms = nms;
        this.containerExecutor = containerExecutor;
        this.worldStorage = worldStorage;
        this.scanTracker = scanTracker;
    }

    public CompletableFuture<Storage> submit(Chunk chunk) {
        return this.submit(chunk, ScanOptions.all());
    }

    public CompletableFuture<Storage> submit(World world, int x, int z) {
        return this.submit(world, x, z, ScanOptions.all());
    }

    public CompletableFuture<Storage> submit(Chunk chunk, ScanOptions options) {
        return this.submit(chunk, ChunkCuboid.maxCuboid(chunk.getWorld()), options);
    }

    public CompletableFuture<Storage> submit(World world, int x, int z, ScanOptions options) {
        return this.submit(world, x, z, ChunkCuboid.maxCuboid(world), options);
    }

    public CompletableFuture<Storage> submit(Chunk chunk, ChunkCuboid cuboid, ScanOptions options) {
        return this.submit(new LoadedChunkContainer(this.nms, chunk, cuboid, options), options);
    }

    public CompletableFuture<Storage> submit(World world, int x, int z, ChunkCuboid cuboid, ScanOptions options) {
        return this.submit(new UnloadedChunkContainer(this.nms, world, x, z, cuboid, options), options);
    }

    public CompletableFuture<Storage> submit(ChunkContainer container, ScanOptions options) {
        World world = container.getWorld();
        ChunkCuboid maxCuboid = ChunkCuboid.maxCuboid(world);
        if (!maxCuboid.contains(container.getChunkCuboid())) {
            return CompletableFuture.failedFuture(new ChunkCuboidOutOfBoundsException(maxCuboid, container.getChunkCuboid()));
        }
        UUID worldUid = world.getUID();
        long chunkKey = container.getChunkKey();
        if (options.track()) {
            this.scanTracker.set(worldUid, chunkKey, true);
        }
        return this.submit(container).thenApply(storage -> {
            if (options.save()) {
                this.worldStorage.getWorld(worldUid).put(chunkKey, (Storage)storage);
            }
            if (options.track()) {
                this.scanTracker.set(worldUid, chunkKey, false);
            }
            MetricsManager metricsManager = InsightsPlugin.getInstance().getMetricsManager();
            metricsManager.getChunkScanMetric().increment();
            metricsManager.getTotalBlocksScanned().add(container.getChunkCuboid().getVolume());
            return storage;
        });
    }

    @Override
    public <T> CompletableFuture<T> submit(SupplierContainer<T> container) {
        return this.containerExecutor.submit(container);
    }

    @Override
    public CompletableFuture<Void> submit(RunnableContainer container) {
        return this.containerExecutor.submit(container);
    }

    @Override
    public void shutdown() {
        this.containerExecutor.shutdown();
    }
}

