/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.dependencies.paperlib.PaperLib;
import java.util.concurrent.CompletableFuture;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChunkTeleport {
    private final InsightsPlugin plugin;

    public ChunkTeleport(InsightsPlugin plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<Result> teleportPlayerToChunk(Player player, World world, int x, int z, boolean gen) {
        CompletableFuture<Result> resultFuture = new CompletableFuture<Result>();
        PaperLib.getChunkAtAsync(world, x, z, gen).whenComplete((chunk, chunkErr) -> {
            if (chunkErr != null) {
                resultFuture.completeExceptionally((Throwable)chunkErr);
                return;
            }
            if (chunk == null) {
                resultFuture.complete(Result.NOT_GENERATED);
                return;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                int blockX = (x << 4) + 8;
                int blockZ = (z << 4) + 8;
                int blockY = world.getHighestBlockYAt(blockX, blockZ, HeightMap.MOTION_BLOCKING) + 1;
                Location loc = new Location(world, (double)blockX + 0.5, (double)blockY, (double)blockZ + 0.5);
                PaperLib.teleportAsync((Entity)player, loc).whenComplete((success, tpErr) -> {
                    if (tpErr != null) {
                        resultFuture.completeExceptionally((Throwable)tpErr);
                    } else if (Boolean.FALSE.equals(success)) {
                        resultFuture.complete(Result.FAILED);
                    } else {
                        resultFuture.complete(Result.SUCCESS);
                    }
                });
            });
        });
        return resultFuture;
    }

    public static enum Result {
        NOT_GENERATED,
        FAILED,
        SUCCESS;

    }
}

