/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class PlayerList
implements Iterable<Map.Entry<UUID, Player>> {
    private final Map<UUID, Player> players = new ConcurrentHashMap<UUID, Player>();

    public PlayerList(Collection<? extends Player> players) {
        for (Player player : players) {
            this.addPlayer(player);
        }
    }

    public void addPlayer(Player player) {
        this.players.put(player.getUniqueId(), player);
    }

    public void removePlayer(Player player) {
        this.players.remove(player.getUniqueId());
    }

    public int size() {
        return this.players.size();
    }

    @Override
    public Iterator<Map.Entry<UUID, Player>> iterator() {
        return this.players.entrySet().iterator();
    }
}

