/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent.containers;

import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.concurrent.containers.SupplierContainer;
import dev.frankheijden.insights.api.concurrent.storage.DistributionStorage;
import dev.frankheijden.insights.api.exceptions.ChunkIOException;
import dev.frankheijden.insights.api.objects.chunk.ChunkCuboid;
import dev.frankheijden.insights.api.objects.chunk.ChunkVector;
import dev.frankheijden.insights.api.utils.ChunkUtils;
import dev.frankheijden.insights.nms.core.ChunkEntity;
import dev.frankheijden.insights.nms.core.ChunkSection;
import dev.frankheijden.insights.nms.core.InsightsNMS;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkContainer
implements SupplierContainer<DistributionStorage> {
    protected final InsightsNMS nms;
    protected final World world;
    protected final int chunkX;
    protected final int chunkZ;
    protected final ChunkCuboid cuboid;
    protected final ScanOptions options;
    protected final Map<Material, Long> materialMap;
    protected final Map<EntityType, Long> entityMap;

    protected ChunkContainer(InsightsNMS nms, World world, int chunkX, int chunkZ, ChunkCuboid cuboid, ScanOptions options) {
        this.nms = nms;
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.cuboid = cuboid;
        this.options = options;
        this.materialMap = new EnumMap<Material, Long>(Material.class);
        this.entityMap = new EnumMap<EntityType, Long>(EntityType.class);
    }

    public World getWorld() {
        return this.world;
    }

    public long getChunkKey() {
        return ChunkUtils.getKey(this.chunkX, this.chunkZ);
    }

    public int getX() {
        return this.chunkX;
    }

    public int getZ() {
        return this.chunkZ;
    }

    public ChunkCuboid getChunkCuboid() {
        return this.cuboid;
    }

    public abstract void getChunkSections(Consumer<@NotNull ChunkSection> var1) throws IOException;

    public abstract void getChunkEntities(Consumer<@NotNull ChunkEntity> var1) throws IOException;

    @Override
    public DistributionStorage get() {
        ChunkVector min = this.cuboid.getMin();
        ChunkVector max = this.cuboid.getMax();
        int minX = min.getX();
        int maxX = max.getX();
        int minZ = min.getZ();
        int maxZ = max.getZ();
        int blockMinY = Math.max(min.getY(), 0);
        int blockMaxY = Math.abs(Math.min(min.getY(), 0)) + max.getY();
        if (this.options.materials()) {
            int minSectionY = blockMinY >> 4;
            int maxSectionY = blockMaxY >> 4;
            try {
                this.getChunkSections(section -> {
                    int maxY;
                    int sectionY = section.index();
                    if (sectionY < minSectionY || sectionY > maxSectionY) {
                        return;
                    }
                    int minY = sectionY == minSectionY ? blockMinY & 0xF : 0;
                    int n = maxY = sectionY == maxSectionY ? blockMaxY & 0xF : 15;
                    if (section.isNull()) {
                        long count2 = ((long)(maxX - minX) + 1L) * 16L * ((long)(maxZ - minZ) + 1L);
                        this.materialMap.merge(Material.AIR, count2, Long::sum);
                    } else if (minX == 0 && maxX == 15 && minY == 0 && maxY == 15 && minZ == 0 && maxZ == 15) {
                        section.countBlocks((material, count) -> {
                            try {
                                this.materialMap.merge((Material)material, (long)count, Long::sum);
                            }
                            catch (Throwable th) {
                                th.printStackTrace();
                            }
                        });
                    } else {
                        for (int x = minX; x <= maxX; ++x) {
                            for (int y = minY; y <= maxY; ++y) {
                                for (int z = minZ; z <= maxZ; ++z) {
                                    this.materialMap.merge(section.blockAt(x, y, z), 1L, Long::sum);
                                }
                            }
                        }
                    }
                });
            }
            catch (IOException ex) {
                throw new ChunkIOException(ex);
            }
        }
        if (this.options.entities()) {
            try {
                this.getChunkEntities(entity -> {
                    int x = entity.x() & 0xF;
                    int y = entity.y() + Math.abs(this.world.getMinHeight());
                    int z = entity.z() & 0xF;
                    if (minX <= x && x <= maxX && blockMinY <= y && y <= blockMaxY && minZ <= z && z <= maxZ) {
                        this.entityMap.merge(entity.type(), 1L, Long::sum);
                    }
                });
            }
            catch (IOException ex) {
                throw new ChunkIOException(ex);
            }
        }
        return DistributionStorage.of(this.materialMap, this.entityMap);
    }
}

