/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent.count;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.concurrent.count.IntegerCount;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TickResetCount<T> {
    private final InsightsPlugin plugin;
    private final int intervalTicks;
    private final int size;
    private final Map<T, IntegerCount> counts;
    private final ResetTask resetTask;
    private BukkitTask bukkitTask = null;

    public TickResetCount(InsightsPlugin plugin, int intervalTicks, int size) {
        this.plugin = plugin;
        this.intervalTicks = intervalTicks;
        this.size = size;
        this.counts = new ConcurrentHashMap<T, IntegerCount>();
        this.resetTask = new ResetTask();
    }

    public void start() {
        if (this.bukkitTask != null) {
            throw new IllegalStateException("ResetTask is already running!");
        }
        this.bukkitTask = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)this.resetTask, 0L, (long)this.intervalTicks);
    }

    public void stop() {
        if (this.bukkitTask == null) {
            throw new IllegalStateException("ResetTask is not running!");
        }
        this.bukkitTask.cancel();
        this.bukkitTask = null;
    }

    public int getCurrentTick() {
        return this.resetTask.tick;
    }

    public int increment(T key) {
        return this.counts.computeIfAbsent(key, k -> new IntegerCount(this.size)).increment(this.resetTask.tick);
    }

    public void remove(T key) {
        this.counts.remove(key);
    }

    public class ResetTask
    implements Runnable {
        private int tick = 0;

        @Override
        public void run() {
            int nextTick = this.tick + 1;
            if (nextTick >= TickResetCount.this.size) {
                nextTick = 0;
            }
            for (IntegerCount value : TickResetCount.this.counts.values()) {
                value.reset(nextTick);
            }
            this.tick = nextTick;
        }
    }
}

