/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent.storage;

import dev.frankheijden.insights.api.utils.MapUtils;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class Distribution<E> {
    protected final Map<E, Long> distributionMap;

    public Distribution(Map<E, Long> distributionMap) {
        this.distributionMap = distributionMap;
    }

    public long count() {
        long count = 0L;
        for (long distribution : this.distributionMap.values()) {
            count += distribution;
        }
        return count;
    }

    public long count(E item) {
        return item == null ? 0L : this.distributionMap.getOrDefault(item, 0L);
    }

    public long count(Predicate<E> predicate) {
        long count = 0L;
        for (Map.Entry<E, Long> entry : this.distributionMap.entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            count += entry.getValue().longValue();
        }
        return count;
    }

    public void modify(E item, long amount) {
        if (item == null) {
            return;
        }
        this.distributionMap.compute(item, (e, count) -> {
            if (count == null) {
                count = 0L;
            }
            return Math.max(0L, count + amount);
        });
    }

    public Set<E> keys() {
        return this.distributionMap.keySet();
    }

    public void mergeRight(Distribution<E> target) {
        MapUtils.mergeRight(this.distributionMap, target.distributionMap, Long::sum);
    }

    public Distribution<E> copy(Map<E, Long> map) {
        map.putAll(this.distributionMap);
        return new Distribution<E>(map);
    }
}

