/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent.storage;

import dev.frankheijden.insights.api.concurrent.storage.Distribution;
import dev.frankheijden.insights.api.concurrent.storage.Storage;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class DistributionStorage
extends Distribution<ScanObject<?>>
implements Storage {
    public DistributionStorage() {
        this(new ConcurrentHashMap());
    }

    public DistributionStorage(Map<ScanObject<?>, Long> map) {
        super(map);
    }

    public static DistributionStorage of(Distribution<Material> materials, Distribution<EntityType> entities) {
        return DistributionStorage.of(materials.distributionMap, entities.distributionMap);
    }

    public static DistributionStorage of(Map<Material, Long> materials, Map<EntityType, Long> entities) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        for (Map.Entry<Material, Long> entry : materials.entrySet()) {
            map.put(ScanObject.of(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<Material, Long> entry : entities.entrySet()) {
            map.put(ScanObject.of((EntityType)entry.getKey()), entry.getValue());
        }
        return new DistributionStorage(map);
    }

    public DistributionStorage copy(Map<ScanObject<?>, Long> map) {
        map.putAll(this.distributionMap);
        return new DistributionStorage(map);
    }
}

