/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent.storage;

import dev.frankheijden.insights.api.concurrent.storage.Distribution;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.config.limits.LimitType;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;

public interface Storage {
    public Set<ScanObject<?>> keys();

    default public long count() {
        return this.count(this.keys());
    }

    public long count(ScanObject<?> var1);

    default public long count(Collection<? extends ScanObject<?>> items) {
        long count = 0L;
        for (ScanObject<?> item : items) {
            count += this.count(item);
        }
        return count;
    }

    default public long count(Limit limit) {
        return this.count(limit.getScanObjects());
    }

    default public long count(Limit limit, ScanObject<?> item) {
        return limit.getType() == LimitType.PERMISSION ? this.count(item) : this.count(limit);
    }

    default public long count(Predicate<ScanObject<?>> predicate) {
        long count = 0L;
        for (ScanObject<?> key : this.keys()) {
            if (!predicate.test(key)) continue;
            count += this.count(key);
        }
        return count;
    }

    public void modify(ScanObject<?> var1, long var2);

    public void mergeRight(Distribution<ScanObject<?>> var1);
}

