/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.concurrent.tracker;

import dev.frankheijden.insights.api.concurrent.tracker.ChunkScanTracker;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class WorldChunkScanTracker {
    private final Map<UUID, ChunkScanTracker> scanTrackerMap = new ConcurrentHashMap<UUID, ChunkScanTracker>();

    public ChunkScanTracker getChunkScanTracker(UUID worldUid) {
        return this.scanTrackerMap.computeIfAbsent(worldUid, k -> new ChunkScanTracker());
    }

    public void set(UUID worldUid, long chunkKey, boolean queued) {
        this.getChunkScanTracker(worldUid).set(chunkKey, queued);
    }

    public boolean isQueued(UUID worldUid, long chunkKey) {
        return this.getChunkScanTracker(worldUid).isQueued(chunkKey);
    }
}

