/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.utils.SetUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class Limits {
    private final List<Limit> limits = new ArrayList<Limit>();
    private final Map<String, Limit> limitsByFileName = new ConcurrentHashMap<String, Limit>();
    private final Map<Material, TreeSet<Limit>> materialLimits = new EnumMap<Material, TreeSet<Limit>>(Material.class);
    private final Map<EntityType, TreeSet<Limit>> entityLimits = new EnumMap<EntityType, TreeSet<Limit>>(EntityType.class);

    public void addLimit(Limit limit) {
        this.limits.add(limit);
        this.limitsByFileName.put(limit.getFile().getName(), limit);
        for (Material m : limit.getMaterials()) {
            this.materialLimits.computeIfAbsent(m, k -> new TreeSet<Limit>(Comparator.comparingInt(l -> l.getLimit((Material)k).getLimit()))).add(limit);
        }
        for (EntityType e : limit.getEntities()) {
            this.entityLimits.computeIfAbsent(e, k -> new TreeSet<Limit>(Comparator.comparingInt(l -> l.getLimit((EntityType)k).getLimit()))).add(limit);
        }
    }

    public List<Limit> getLimits() {
        return new ArrayList<Limit>(this.limits);
    }

    public Optional<Limit> getFirstLimit(ScanObject<?> item, Predicate<Limit> limitPredicate) {
        switch (item.getType()) {
            case MATERIAL: {
                return this.getFirstLimit((Material)item.getObject(), limitPredicate);
            }
            case ENTITY: {
                return this.getFirstLimit((EntityType)item.getObject(), limitPredicate);
            }
        }
        throw new IllegalArgumentException("Item is of unsupported limit type '" + String.valueOf(item.getClass()) + "'");
    }

    public Optional<Limit> getFirstLimit(Material material, Predicate<Limit> limitPredicate) {
        InsightsPlugin.getInstance().getMetricsManager().getLimitMetric().increment();
        Set set = this.materialLimits.get(material);
        return set == null ? Optional.empty() : Optional.ofNullable(SetUtils.findFirst(set, limitPredicate));
    }

    public Optional<Limit> getFirstLimit(EntityType entity, Predicate<Limit> limitPredicate) {
        InsightsPlugin.getInstance().getMetricsManager().getLimitMetric().increment();
        Set set = this.entityLimits.get(entity);
        return set == null ? Optional.empty() : Optional.ofNullable(SetUtils.findFirst(set, limitPredicate));
    }

    public Optional<Limit> getLimitByFileName(String fileName) {
        return Optional.ofNullable(this.limitsByFileName.get(fileName));
    }

    public Set<String> getLimitFileNames() {
        return new HashSet<String>(this.limitsByFileName.keySet());
    }
}

