/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.config.parser.PassiveYamlParser;
import dev.frankheijden.insights.api.config.parser.YamlParser;
import dev.frankheijden.insights.api.objects.chunk.ChunkLocation;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.utils.StringUtils;
import dev.frankheijden.insights.dependencies.adventure.audience.Audience;
import dev.frankheijden.insights.dependencies.adventure.platform.bukkit.BukkitAudiences;
import dev.frankheijden.insights.dependencies.adventure.text.Component;
import dev.frankheijden.insights.dependencies.adventure.text.TextComponent;
import dev.frankheijden.insights.dependencies.adventure.text.event.ClickEvent;
import dev.frankheijden.insights.dependencies.adventure.text.event.HoverEvent;
import dev.frankheijden.insights.dependencies.adventure.text.format.NamedTextColor;
import dev.frankheijden.insights.dependencies.adventure.text.format.TextColor;
import dev.frankheijden.insights.dependencies.adventure.text.minimessage.MiniMessage;
import dev.frankheijden.insights.dependencies.adventure.text.minimessage.tag.Tag;
import dev.frankheijden.insights.dependencies.adventure.text.minimessage.tag.resolver.TagResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class Messages {
    private final InsightsPlugin plugin;
    private final BukkitAudiences audiences;
    private final YamlParser parser;
    private final MiniMessage miniMessage;
    private final Map<Key, String> messageCache;
    private final TagResolver prefixResolver;

    protected Messages(InsightsPlugin plugin, BukkitAudiences audiences, YamlParser parser) {
        this.plugin = plugin;
        this.audiences = audiences;
        this.parser = parser;
        this.miniMessage = MiniMessage.miniMessage();
        this.messageCache = new EnumMap<Key, String>(Key.class);
        this.prefixResolver = Messages.tagOf("prefix", this.miniMessage.deserialize(this.getRawMessage(Key.PREFIX)));
    }

    public BukkitAudiences getAudiences() {
        return this.audiences;
    }

    public Message getMessage(Key messageKey) {
        return this.createMessage(this.getRawMessage(messageKey));
    }

    public String getRawMessage(Key messageKey) {
        return this.messageCache.computeIfAbsent(messageKey, k -> this.parser.getRawString(k.getPath()));
    }

    public <T> PaginatedMessage<T> createPaginatedMessage(Message header, Key formatKey, Message footer, T[] keys, ToLongFunction<T> countFunction, Function<T, Component> displayNameFunction) {
        return new PaginatedMessage<Object>(header, footer, keys, element -> {
            Component displayName = (Component)displayNameFunction.apply(element);
            Component component = this.miniMessage.deserialize(this.getRawMessage(formatKey), TagResolver.resolver(Messages.tagOf("entry", displayName), Messages.tagOf("count", StringUtils.pretty(countFunction.applyAsLong(element)))));
            return this.addHover(component, element, displayName);
        }, this.plugin.getSettings().PAGINATION_RESULTS_PER_PAGE);
    }

    private <T> Component addHover(Component component, T element, Component displayName) {
        if (element instanceof ScanObject) {
            ScanObject scanObject = (ScanObject)element;
            Object obj = scanObject.getObject();
            if (obj instanceof Material) {
                Material material = (Material)obj;
                NamespacedKey key = material.getKey();
                if (material.isItem()) {
                    return component.hoverEvent(HoverEvent.showItem(dev.frankheijden.insights.dependencies.adventure.key.Key.key(key.getNamespace(), key.getKey()), 1));
                }
                return component.hoverEvent(HoverEvent.showText(displayName.append(Component.newline()).append(Component.text(key.toString(), (TextColor)NamedTextColor.DARK_GRAY))));
            }
            if (obj instanceof EntityType) {
                EntityType type = (EntityType)obj;
                NamespacedKey key = type.getKey();
                return component.hoverEvent(HoverEvent.showText(((TextComponent)((TextComponent)Component.text("Type: ").append(displayName)).append(Component.newline())).append(Component.text(key.toString(), (TextColor)NamedTextColor.DARK_GRAY))));
            }
        } else if (element instanceof ChunkLocation) {
            ChunkLocation chunkLoc = (ChunkLocation)element;
            Object hoverComponent = this.miniMessage.deserialize(this.getRawMessage(Key.SCAN_FINISH_CHUNK_HOVER));
            String tpCommand = "/tpchunk " + chunkLoc.getWorld().getName() + " " + chunkLoc.getX() + " " + chunkLoc.getZ();
            return component.hoverEvent(HoverEvent.showText(hoverComponent)).clickEvent(ClickEvent.runCommand(tpCommand));
        }
        return component;
    }

    public static Messages load(InsightsPlugin plugin, BukkitAudiences audiences, File file, InputStream defaultSettings) throws IOException {
        return new Messages(plugin, audiences, PassiveYamlParser.load(file, defaultSettings));
    }

    public static TagResolver tagOf(String name, String content) {
        return Messages.tagOf(name, Component.text(content));
    }

    public static TagResolver tagOf(String name, int value) {
        return Messages.tagOf(name, Component.text(value));
    }

    public static TagResolver tagOf(String name, Component content) {
        return TagResolver.resolver(name, Tag.inserting(content));
    }

    public Message createMessage(String str) {
        if (str == null) {
            return new Message();
        }
        String upper = str.toUpperCase(Locale.ENGLISH);
        Message.Type messageType = Message.Type.CHAT;
        for (Message.Type type : Message.Type.values()) {
            if (!upper.startsWith("<" + type.name() + ">")) continue;
            int offset = 2 + type.name().length();
            str = str.substring(offset);
            upper = upper.substring(offset);
            messageType = type;
            break;
        }
        return new Message(str, messageType, this.prefixResolver);
    }

    public static enum Key {
        PREFIX("prefix"),
        UPDATE_AVAILABLE("update-available"),
        CONFIGS_RELOADED("configs-reloaded"),
        AREA_SCAN_STARTED("area-scan-started"),
        AREA_SCAN_QUEUED("area-scan-queued"),
        AREA_SCAN_COMPLETED("area-scan-completed"),
        LIMIT_REACHED("limit-reached"),
        LIMIT_NOTIFICATION("limit-notification"),
        LIMIT_DISALLOWED_PLACEMENT("limit-disallowed-placement"),
        SCAN_START("scan.start"),
        SCAN_ALREADY_SCANNING("scan.already-scanning"),
        SCAN_FINISH_HEADER("scan.finish.header"),
        SCAN_FINISH_CHUNK_FORMAT("scan.finish.chunk-format"),
        SCAN_FINISH_CHUNK_HOVER("scan.finish.chunk-hover"),
        SCAN_FINISH_FORMAT("scan.finish.format"),
        SCAN_FINISH_FOOTER("scan.finish.footer"),
        SCAN_PROGRESS("scan.progress"),
        SCANREGION_NO_REGION("scanregion.no-region"),
        SCANCACHE_NO_CACHE("scancache.no-cache"),
        SCANCACHE_CLEARED("scancache.cleared"),
        SCANCACHE_RESULT_HEADER("scancache.result.header"),
        SCANCACHE_RESULT_FORMAT("scancache.result.format"),
        SCANCACHE_RESULT_FOOTER("scancache.result.footer"),
        SCANHISTORY_NO_HISTORY("scanhistory.no-history"),
        PAGINATION_BUTTON_LEFT("pagination.button-left"),
        PAGINATION_BUTTON_RIGHT("pagination.button-right"),
        PAGINATION_BUTTON_COLOR_ACTIVE("pagination.button-color-active"),
        PAGINATION_BUTTON_COLOR_INACTIVE("pagination.button-color-inactive"),
        PAGINATION_BUTTON_HOVER("pagination.button-hover"),
        PAGINATION_ENTRY_FORMAT("pagination.entry-format"),
        PAGINATION_FOOTER_FORMAT("pagination.footer-format"),
        PAGINATION_NO_PAGE("pagination.no-page"),
        PAGINATION_NO_RESULTS("pagination.no-results"),
        STATS("stats"),
        TELEPORTCHUNK_ERROR("teleportchunk.error"),
        TELEPORTCHUNK_NOT_GENERATED("teleportchunk.not-generated"),
        TELEPORTCHUNK_FAILED("teleportchunk.failed"),
        TELEPORTCHUNK_SUCCESS("teleportchunk.success"),
        CANCELSCAN_NO_SCAN("cancelscan.no-scan");

        private final String path;

        private Key(String path) {
            this.path = "messages." + path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class Message {
        private String content;
        private final Type type;
        private final TagResolver originalResolver;
        private TagResolver resolver;

        private Message() {
            this(null, Type.CHAT, TagResolver.empty());
        }

        private Message(String content, Type type, TagResolver resolver) {
            this.content = content;
            this.type = type;
            this.originalResolver = resolver;
            this.resolver = resolver;
        }

        public Message resetTemplates() {
            this.resolver = this.originalResolver;
            return this;
        }

        public Message addTemplates(TagResolver resolver) {
            this.resolver = TagResolver.resolver(this.resolver, resolver);
            return this;
        }

        public Message addTemplates(TagResolver ... resolvers) {
            this.resolver = TagResolver.resolver(this.resolver, TagResolver.resolver(resolvers));
            return this;
        }

        public void setRawContent(String content) {
            this.content = content;
        }

        public String getRawContent() {
            return this.content;
        }

        public Optional<Component> toComponent() {
            if (this.content == null || this.content.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Messages.this.miniMessage.deserialize(this.content, this.resolver));
        }

        public void sendTo(CommandSender sender) {
            this.sendTo(Messages.this.audiences.sender(sender));
        }

        public void sendTo(Audience audience) {
            if (this.content != null && !this.content.isEmpty()) {
                Component component = Messages.this.miniMessage.deserialize(this.content, this.resolver);
                if (this.type == Type.ACTIONBAR) {
                    audience.sendActionBar(component);
                } else {
                    audience.sendMessage(component);
                }
            }
        }

        private static enum Type {
            ACTIONBAR,
            CHAT;

        }
    }

    public class PaginatedMessage<T> {
        private final Message header;
        private final Message footer;
        private final T[] elements;
        private final Function<T, Component> elementFormatFunction;
        private final int amountPerPage;

        private PaginatedMessage(Message header, Message footer, T[] elements, Function<T, Component> elementFormatFunction, int amountPerPage) {
            this.header = header;
            this.footer = footer;
            this.elements = elements;
            this.elementFormatFunction = elementFormatFunction;
            this.amountPerPage = amountPerPage;
        }

        public int getPageAmount() {
            return (int)Math.ceil((double)this.elements.length / (double)this.amountPerPage);
        }

        private Component createFooter(int page) {
            return Messages.this.miniMessage.deserialize(Messages.this.getRawMessage(Key.PAGINATION_FOOTER_FORMAT), TagResolver.resolver(Messages.tagOf("current-page", page + 1), Messages.tagOf("page-amount", this.getPageAmount()), Messages.tagOf("button-left", this.createButton(page, ButtonType.LEFT)), Messages.tagOf("button-right", this.createButton(page, ButtonType.RIGHT))));
        }

        private Component createButton(int page, ButtonType type) {
            Key buttonColor;
            TextComponent.Builder button = (TextComponent.Builder)Component.empty().toBuilder();
            if (type == ButtonType.LEFT && page == 0 || type == ButtonType.RIGHT && page == this.getPageAmount() - 1) {
                buttonColor = Key.PAGINATION_BUTTON_COLOR_INACTIVE;
            } else {
                buttonColor = Key.PAGINATION_BUTTON_COLOR_ACTIVE;
                int clickPage = type == ButtonType.LEFT ? page : page + 2;
                button.hoverEvent(HoverEvent.showText(Messages.this.miniMessage.deserialize(Messages.this.getRawMessage(Key.PAGINATION_BUTTON_HOVER), Messages.tagOf("page", clickPage))));
                button.clickEvent(ClickEvent.runCommand("/scanhistory " + clickPage));
            }
            button.append((Component)Messages.this.miniMessage.deserialize(Messages.this.getRawMessage(buttonColor) + Messages.this.getRawMessage(type.key)));
            return button.build();
        }

        public void sendTo(CommandSender sender, int page) {
            if (this.elements.length == 0) {
                Messages.this.getMessage(Key.PAGINATION_NO_RESULTS).sendTo(sender);
                return;
            }
            int offsetStart = this.amountPerPage * page;
            int offsetEnd = Math.min(offsetStart + this.amountPerPage, this.elements.length);
            if (offsetStart >= this.elements.length) {
                Messages.this.getMessage(Key.PAGINATION_NO_PAGE).sendTo(sender);
                return;
            }
            ArrayList<Component> components = new ArrayList<Component>(this.amountPerPage);
            for (int i = offsetStart; i < offsetEnd; ++i) {
                components.add(this.elementFormatFunction.apply(this.elements[i]));
            }
            Audience audience = Messages.this.audiences.sender(sender);
            this.header.sendTo(sender);
            components.forEach(audience::sendMessage);
            this.footer.sendTo(sender);
            audience.sendMessage(this.createFooter(page));
        }

        private static enum ButtonType {
            LEFT(Key.PAGINATION_BUTTON_LEFT),
            RIGHT(Key.PAGINATION_BUTTON_RIGHT);

            Key key;

            private ButtonType(Key key) {
                this.key = key;
            }
        }
    }
}

