/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.Settings;
import dev.frankheijden.insights.api.config.notifications.AbstractNotificationFactory;
import dev.frankheijden.insights.api.config.notifications.Notification;
import dev.frankheijden.insights.api.config.notifications.NotificationFactory;
import dev.frankheijden.insights.api.config.notifications.ProgressNotification;
import dev.frankheijden.insights.api.config.notifications.ProgressNotificationFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Notifications {
    private final NotificationFactory notificationFactory;
    private final ProgressNotificationFactory progressNotificationFactory;
    private final Messages messages;
    private final Settings.NotificationType type;
    private final Map<UUID, Cache<Notification>> notificationMap = new HashMap<UUID, Cache<Notification>>();
    private final Map<UUID, Cache<ProgressNotification>> progressNotificationMap = new HashMap<UUID, Cache<ProgressNotification>>();

    public Notifications(InsightsPlugin plugin) {
        this.notificationFactory = new NotificationFactory(plugin);
        this.progressNotificationFactory = new ProgressNotificationFactory(plugin);
        this.messages = plugin.getMessages();
        this.type = plugin.getSettings().NOTIFICATION_TYPE;
    }

    private <T extends Notification> T createNotification(AbstractNotificationFactory<T> factory, Messages.Message content) {
        return (T)(switch (this.type) {
            case Settings.NotificationType.ACTIONBAR -> (Notification)factory.actionBar(content);
            case Settings.NotificationType.BOSSBAR -> (Notification)factory.bossBar(content);
            default -> throw new IllegalArgumentException("Notification Type '" + String.valueOf((Object)this.type) + "' is not implemented!");
        });
    }

    private <T extends Notification> T get(AbstractNotificationFactory<T> factory, Messages.Key key) {
        Messages.Message message = this.messages.getMessage(key);
        return message == null ? factory.empty() : this.createNotification(factory, message);
    }

    public Notification get(Messages.Key messageKey) {
        return this.get(this.notificationFactory, messageKey);
    }

    public Notification getCached(UUID uuid, Messages.Key messageKey) {
        return this.notificationMap.compute(uuid, (uuid1, cache) -> {
            if (cache == null || cache.getKey() != messageKey) {
                return new Cache<Notification>(this.get(messageKey), messageKey);
            }
            return cache;
        }).getNotification();
    }

    public ProgressNotification getCachedProgress(UUID uuid, Messages.Key messageKey) {
        return (ProgressNotification)this.progressNotificationMap.compute(uuid, (uuid1, cache) -> {
            if (cache == null || cache.getKey() != messageKey) {
                return new Cache<ProgressNotification>(this.getProgress(messageKey), messageKey);
            }
            return cache;
        }).getNotification();
    }

    public ProgressNotification getProgress(Messages.Key messageKey) {
        return this.get(this.progressNotificationFactory, messageKey);
    }

    public void clearNotifications() {
        for (Cache<Notification> cache : this.notificationMap.values()) {
            cache.getNotification().clear();
        }
        this.notificationMap.clear();
        for (Cache<Notification> cache : this.progressNotificationMap.values()) {
            ((ProgressNotification)cache.getNotification()).clear();
        }
        this.progressNotificationMap.clear();
    }

    private static final class Cache<T extends Notification> {
        private final T notification;
        private final Messages.Key key;

        private Cache(T notification, Messages.Key key) {
            this.notification = notification;
            this.key = key;
        }

        public T getNotification() {
            return this.notification;
        }

        public Messages.Key getKey() {
            return this.key;
        }
    }
}

