/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.limits;

import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.config.limits.LimitInfo;
import dev.frankheijden.insights.api.config.limits.LimitType;
import dev.frankheijden.insights.api.config.parser.YamlParseException;
import dev.frankheijden.insights.api.config.parser.YamlParser;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class GroupLimit
extends Limit {
    private final String name;
    private final int limit;
    private final Set<Material> materials;
    private final Set<EntityType> entities;
    private final Set<ScanObject<?>> scanObjects;
    private final ScanOptions scanOptions;

    protected GroupLimit(Limit.Info info, String name, int limit, Set<Material> materials, Set<EntityType> entities) {
        super(LimitType.GROUP, info);
        this.name = name;
        this.limit = limit;
        this.materials = Collections.unmodifiableSet(materials);
        this.entities = Collections.unmodifiableSet(entities);
        this.scanObjects = Collections.unmodifiableSet(ScanObject.of(materials, entities));
        this.scanOptions = this.determineScanOptions();
    }

    public static GroupLimit parse(YamlParser parser, Limit.Info info) throws YamlParseException {
        String name = parser.getString("limit.name", null, true);
        int limit = parser.getInt("limit.limit", -1, 0, Integer.MAX_VALUE);
        boolean regex = parser.getBoolean("limit.regex", false, false);
        List<Material> materials = regex ? parser.getRegexEnums("limit.materials", Material.class) : parser.getEnums("limit.materials", Material.class, "material");
        List<EntityType> entities = regex ? parser.getRegexEnums("limit.entities", EntityType.class) : parser.getEnums("limit.entities", EntityType.class, "entity");
        return new GroupLimit(info, name, limit, materials.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(materials), entities.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(entities));
    }

    public String getName() {
        return this.name;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public LimitInfo getLimit(Material m) {
        return new LimitInfo(this.name, this.limit);
    }

    @Override
    public LimitInfo getLimit(EntityType e) {
        return new LimitInfo(this.name, this.limit);
    }

    @Override
    public Set<Material> getMaterials() {
        return this.materials;
    }

    @Override
    public Set<EntityType> getEntities() {
        return this.entities;
    }

    @Override
    public Set<? extends ScanObject<?>> getScanObjects() {
        return this.scanObjects;
    }

    @Override
    public ScanOptions getScanOptions() {
        return this.scanOptions;
    }
}

