/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.limits;

import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.config.limits.GroupLimit;
import dev.frankheijden.insights.api.config.limits.LimitInfo;
import dev.frankheijden.insights.api.config.limits.LimitParseException;
import dev.frankheijden.insights.api.config.limits.LimitSettings;
import dev.frankheijden.insights.api.config.limits.LimitType;
import dev.frankheijden.insights.api.config.limits.PermissionLimit;
import dev.frankheijden.insights.api.config.limits.TileLimit;
import dev.frankheijden.insights.api.config.parser.SensitiveYamlParser;
import dev.frankheijden.insights.api.config.parser.YamlParseException;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public abstract class Limit {
    private static final String LIMIT_SECTION = "limit";
    private final LimitType type;
    private final Info info;

    protected Limit(LimitType type, Info info) {
        this.type = type;
        this.info = info;
    }

    public static Limit parse(File file) throws IOException, YamlParseException {
        SensitiveYamlParser parser = SensitiveYamlParser.load(file);
        if (!parser.checkExists(LIMIT_SECTION)) {
            throw new LimitParseException("Section 'limit' does not exist!");
        }
        LimitType type = parser.getEnum("limit.type", LimitType.class);
        if (type == null) {
            throw new LimitParseException("Invalid limit type!");
        }
        String bypassPermission = parser.getString("limit.bypass-permission", null, false);
        boolean worldWhitelist = parser.getBoolean("limit.settings.enabled-worlds.whitelist", false, false);
        Set<String> worlds = parser.getSet("limit.settings.enabled-worlds.worlds");
        boolean addonWhitelist = parser.getBoolean("limit.settings.enabled-addons.whitelist", false, false);
        Set<String> addons = parser.getSet("limit.settings.enabled-addons.addons");
        boolean disallowPlacement = parser.getBoolean("limit.settings.disallow-placement-outside-region", false, false);
        LimitSettings settings = new LimitSettings(worlds, worldWhitelist, addons, addonWhitelist, disallowPlacement);
        Info info = new Info(file, bypassPermission, settings);
        return switch (type) {
            case LimitType.TILE -> TileLimit.parse(parser, info);
            case LimitType.GROUP -> GroupLimit.parse(parser, info);
            case LimitType.PERMISSION -> PermissionLimit.parse(parser, info);
            default -> throw new LimitParseException("Limit implementation is missing!");
        };
    }

    public LimitType getType() {
        return this.type;
    }

    public LimitInfo getLimit(ScanObject<?> item) {
        return switch (item.getType()) {
            case ScanObject.Type.MATERIAL -> this.getLimit((Material)item.getObject());
            case ScanObject.Type.ENTITY -> this.getLimit((EntityType)item.getObject());
            default -> throw new IllegalArgumentException("Unknown limited item: " + String.valueOf(item));
        };
    }

    public abstract LimitInfo getLimit(Material var1);

    public abstract LimitInfo getLimit(EntityType var1);

    public File getFile() {
        return this.info.file;
    }

    public String getBypassPermission() {
        return this.info.bypassPermission;
    }

    public LimitSettings getSettings() {
        return this.info.settings;
    }

    public Info getInfo() {
        return this.info;
    }

    public abstract Set<Material> getMaterials();

    public abstract Set<EntityType> getEntities();

    public abstract Set<? extends ScanObject<?>> getScanObjects();

    protected ScanOptions determineScanOptions() {
        if (this.getMaterials().isEmpty()) {
            return ScanOptions.entitiesOnly();
        }
        if (this.getEntities().isEmpty()) {
            return ScanOptions.materialsOnly();
        }
        return ScanOptions.scanOnly();
    }

    public abstract ScanOptions getScanOptions();

    public static class Info {
        private final File file;
        private final String bypassPermission;
        private final LimitSettings settings;

        public Info(File file, String bypassPermission, LimitSettings settings) {
            this.file = file;
            this.bypassPermission = bypassPermission;
            this.settings = settings;
        }

        public String getBypassPermission() {
            return this.bypassPermission;
        }

        public LimitSettings getSettings() {
            return this.settings;
        }
    }
}

