/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.limits;

import java.util.Set;

public class LimitSettings {
    private final Set<String> worlds;
    private final boolean worldWhitelist;
    private final Set<String> addons;
    private final boolean addonWhitelist;
    private final boolean disallowPlacementOutsideRegion;

    public LimitSettings(Set<String> worlds, boolean worldWhitelist, Set<String> addons, boolean addonWhitelist, boolean disallowPlacementOutsideRegion) {
        this.worlds = worlds;
        this.worldWhitelist = worldWhitelist;
        this.addons = addons;
        this.addonWhitelist = addonWhitelist;
        this.disallowPlacementOutsideRegion = disallowPlacementOutsideRegion;
    }

    public Set<String> getWorlds() {
        return this.worlds;
    }

    public boolean isWorldWhitelist() {
        return this.worldWhitelist;
    }

    public boolean appliesToWorld(String worldName) {
        if (this.worldWhitelist) {
            return this.worlds.contains(worldName);
        }
        return !this.worlds.contains(worldName);
    }

    public Set<String> getAddons() {
        return this.addons;
    }

    public boolean isAddonWhitelist() {
        return this.addonWhitelist;
    }

    public boolean isDisallowedPlacementOutsideRegion() {
        return this.disallowPlacementOutsideRegion;
    }

    public boolean appliesToAddon(String addonName) {
        if (this.addonWhitelist) {
            return this.addons.contains(addonName);
        }
        return !this.addons.contains(addonName);
    }
}

