/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.limits;

import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.config.limits.LimitInfo;
import dev.frankheijden.insights.api.config.limits.LimitType;
import dev.frankheijden.insights.api.config.parser.YamlParseException;
import dev.frankheijden.insights.api.config.parser.YamlParser;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.utils.EnumUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class PermissionLimit
extends Limit {
    private final Map<Material, Integer> materials;
    private final Map<EntityType, Integer> entities;
    private final Set<ScanObject<?>> scanObjects;
    private final ScanOptions scanOptions;

    protected PermissionLimit(Limit.Info info, Map<Material, Integer> materials, Map<EntityType, Integer> entities) {
        super(LimitType.PERMISSION, info);
        this.materials = Collections.unmodifiableMap(materials);
        this.entities = Collections.unmodifiableMap(entities);
        this.scanObjects = Collections.unmodifiableSet(ScanObject.of(materials.keySet(), entities.keySet()));
        this.scanOptions = this.determineScanOptions();
    }

    public static PermissionLimit parse(YamlParser parser, Limit.Info info) throws YamlParseException {
        EnumMap<Material, Integer> materials = new EnumMap<Material, Integer>(Material.class);
        for (String key : parser.getKeys("limit.materials")) {
            String fullKey = "limit.materials." + key;
            Material material = parser.checkEnum(fullKey, key, Material.class, null, "material");
            int limit = parser.getInt(fullKey, -1, 0, Integer.MAX_VALUE);
            materials.put(material, limit);
        }
        EnumMap<EntityType, Integer> entities = new EnumMap<EntityType, Integer>(EntityType.class);
        for (String key : parser.getKeys("limit.entities")) {
            String fullKey = "limit.entities." + key;
            EntityType entity = parser.checkEnum(fullKey, key, EntityType.class, null, "entity");
            int limit = parser.getInt(fullKey, -1, 0, Integer.MAX_VALUE);
            entities.put(entity, limit);
        }
        return new PermissionLimit(info, materials, entities);
    }

    @Override
    public LimitInfo getLimit(Material m) {
        return new LimitInfo(EnumUtils.pretty(m), this.materials.getOrDefault(m, -1));
    }

    @Override
    public LimitInfo getLimit(EntityType e) {
        return new LimitInfo(EnumUtils.pretty(e), this.entities.getOrDefault(e, -1));
    }

    @Override
    public Set<Material> getMaterials() {
        return this.materials.keySet();
    }

    @Override
    public Set<EntityType> getEntities() {
        return this.entities.keySet();
    }

    @Override
    public Set<? extends ScanObject<?>> getScanObjects() {
        return this.scanObjects;
    }

    @Override
    public ScanOptions getScanOptions() {
        return this.scanOptions;
    }
}

