/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.limits;

import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.config.limits.LimitInfo;
import dev.frankheijden.insights.api.config.limits.LimitType;
import dev.frankheijden.insights.api.config.parser.YamlParseException;
import dev.frankheijden.insights.api.config.parser.YamlParser;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.reflection.RTileEntityTypes;
import dev.frankheijden.insights.api.utils.EnumUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class TileLimit
extends Limit {
    private final String name;
    private final int limit;
    private final Set<Material> effectiveMaterials;
    private final Set<? extends ScanObject<?>> effectiveScanObjects;
    private final ScanOptions scanOptions;

    protected TileLimit(Limit.Info info, String name, int limit, Set<Material> excludedMaterials) {
        super(LimitType.TILE, info);
        this.name = name;
        this.limit = limit;
        this.effectiveMaterials = EnumUtils.difference(RTileEntityTypes.getTileEntityMaterials(), excludedMaterials);
        HashSet<ScanObject.MaterialObject> tileEntityScanObjects = new HashSet<ScanObject.MaterialObject>(RTileEntityTypes.getTileEntities());
        tileEntityScanObjects.removeAll(ScanObject.of(excludedMaterials));
        this.effectiveScanObjects = Collections.unmodifiableSet(tileEntityScanObjects);
        this.scanOptions = this.determineScanOptions();
    }

    public static TileLimit parse(YamlParser parser, Limit.Info info) throws YamlParseException {
        String name = parser.getString("limit.name", null, true);
        int limit = parser.getInt("limit.limit", -1, 0, Integer.MAX_VALUE);
        HashSet<Material> excludedMaterials = new HashSet<Material>(parser.getEnums("limit.excluded-materials", Material.class));
        return new TileLimit(info, name, limit, excludedMaterials);
    }

    public String getName() {
        return this.name;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public LimitInfo getLimit(Material m) {
        return new LimitInfo(this.name, this.limit);
    }

    @Override
    public LimitInfo getLimit(EntityType e) {
        return new LimitInfo(this.name, -1);
    }

    @Override
    public Set<Material> getMaterials() {
        return this.effectiveMaterials;
    }

    @Override
    public Set<EntityType> getEntities() {
        return Collections.emptySet();
    }

    @Override
    public Set<? extends ScanObject<?>> getScanObjects() {
        return this.effectiveScanObjects;
    }

    @Override
    public ScanOptions getScanOptions() {
        return this.scanOptions;
    }
}

