/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.notifications;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.notifications.ActionBarNotification;
import dev.frankheijden.insights.api.config.notifications.ProgressNotification;

public class ActionBarProgressNotification
extends ActionBarNotification
implements ProgressNotification {
    protected final String rawContent;
    protected final int segments;
    protected final String doneColor;
    protected final String totalColor;
    protected final String progressSequence;
    protected final String separator;

    protected ActionBarProgressNotification(InsightsPlugin plugin, Messages.Message content, int segments, String doneColor, String totalColor, String progressSequence, String separator) {
        super(plugin, content);
        this.rawContent = content.getRawContent();
        this.segments = segments;
        this.doneColor = doneColor;
        this.totalColor = totalColor;
        this.progressSequence = progressSequence;
        this.separator = separator;
    }

    @Override
    public ActionBarProgressNotification progress(float progress) {
        int i;
        progress = Math.max(0.0f, Math.min(1.0f, progress));
        int cut = (int)(progress * (float)this.segments);
        StringBuilder sb = new StringBuilder(this.segments * this.progressSequence.length() + this.doneColor.length() + this.totalColor.length() + this.separator.length() + this.rawContent.length());
        sb.append(this.doneColor);
        for (i = 0; i < cut; ++i) {
            sb.append(this.progressSequence);
        }
        sb.append(this.totalColor);
        for (i = cut; i < this.segments; ++i) {
            sb.append(this.progressSequence);
        }
        this.content.setRawContent(sb.append(this.separator).append(this.rawContent).toString());
        return this;
    }
}

