/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.notifications;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.notifications.Notification;
import dev.frankheijden.insights.api.config.notifications.SendableNotification;
import dev.frankheijden.insights.dependencies.adventure.audience.Audience;
import dev.frankheijden.insights.dependencies.adventure.bossbar.BossBar;
import dev.frankheijden.insights.dependencies.adventure.text.Component;
import java.util.LinkedList;
import java.util.Queue;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BossBarNotification
implements Notification {
    protected final InsightsPlugin plugin;
    protected final BossBar bossBar;
    protected final Messages.Message content;
    protected final Queue<Audience> receivers = new LinkedList<Audience>();
    protected final Queue<Audience> viewers = new LinkedList<Audience>();
    protected final int ticks;
    protected final Runnable bossBarClearer;
    protected BukkitTask task;

    protected BossBarNotification(InsightsPlugin plugin, BossBar bossBar, Messages.Message content, int ticks) {
        this.plugin = plugin;
        this.bossBar = bossBar;
        this.content = content;
        this.ticks = ticks;
        this.bossBarClearer = () -> {
            while (!this.viewers.isEmpty()) {
                this.viewers.poll().hideBossBar(bossBar);
            }
        };
    }

    @Override
    public BossBarNotification add(Player player) {
        this.receivers.add(this.plugin.getMessages().getAudiences().player(player));
        return this;
    }

    @Override
    public SendableNotification create() {
        return new SendableNotification(this.content.resetTemplates()){

            @Override
            public void send() {
                if (BossBarNotification.this.task != null) {
                    BossBarNotification.this.task.cancel();
                }
                BossBarNotification.this.bossBar.name(this.content.toComponent().orElse(Component.empty()));
                while (!BossBarNotification.this.receivers.isEmpty()) {
                    Audience audience = BossBarNotification.this.receivers.poll();
                    audience.showBossBar(BossBarNotification.this.bossBar);
                    BossBarNotification.this.viewers.add(audience);
                }
                BossBarNotification.this.task = Bukkit.getScheduler().runTaskLater((Plugin)BossBarNotification.this.plugin, BossBarNotification.this.bossBarClearer, (long)BossBarNotification.this.ticks);
            }
        };
    }

    @Override
    public void clear() {
        this.bossBarClearer.run();
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

