/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.config.parser;

import dev.frankheijden.insights.api.config.ConfigError;
import dev.frankheijden.insights.api.utils.EnumUtils;
import dev.frankheijden.insights.api.utils.YamlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class YamlParser {
    private final YamlConfiguration yaml;
    private final String name;
    private final Consumer<ConfigError> errorConsumer;

    protected YamlParser(YamlConfiguration yaml, String name, Consumer<ConfigError> errorConsumer) {
        this.yaml = yaml;
        this.name = name;
        this.errorConsumer = errorConsumer;
    }

    public static YamlConfiguration loadYaml(File file) throws IOException {
        return YamlParser.loadYaml(file, null);
    }

    public static YamlConfiguration loadYaml(File file, InputStream defaultSettings) throws IOException {
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        if (defaultSettings != null) {
            YamlConfiguration def = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultSettings));
            YamlUtils.update((ConfigurationSection)yaml, (ConfigurationSection)def);
            YamlUtils.removeUnusedKeys((ConfigurationSection)yaml, (ConfigurationSection)def);
            yaml.save(file);
        }
        return yaml;
    }

    public String getName() {
        return this.name;
    }

    public void addError(ConfigError error) {
        this.errorConsumer.accept(error);
    }

    public static String joinPaths(String ... paths) {
        return String.join((CharSequence)".", paths);
    }

    public Set<String> getKeys(String path) {
        Object obj = this.yaml.get(path);
        if (obj instanceof MemorySection) {
            return ((MemorySection)obj).getKeys(false);
        }
        if (obj != null) {
            this.errorConsumer.accept(new ConfigError(this.name, path, "value is not a section " + String.valueOf(obj)));
        }
        return new HashSet<String>();
    }

    public Map<String, Integer> getIntegerMap(String path, int min, int max, int def) {
        return this.getIntegerMap(path, min, max, def, new HashMap<String, Integer>());
    }

    public Map<String, Integer> getIntegerMap(String path, int min, int max, int def, Map<String, Integer> map) {
        for (String key : this.getKeys(path)) {
            String subPath = YamlParser.joinPaths(path, key);
            int value = this.yaml.getInt(subPath, def);
            if (value < min) {
                this.errorConsumer.accept(new ConfigError(this.name, path, "value must be at least " + min));
                continue;
            }
            if (value > max) {
                this.errorConsumer.accept(new ConfigError(this.name, path, "value must be at most " + max));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public boolean checkExists(String path) {
        boolean exists;
        boolean bl = exists = this.yaml.get(path) != null;
        if (!exists) {
            this.errorConsumer.accept(new ConfigError(this.name, path, "object does not exist"));
        }
        return exists;
    }

    public int getInt(String path, int def, int min, int max) {
        if (!this.yaml.isInt(path)) {
            this.errorConsumer.accept(new ConfigError(this.name, path, "value is not an integer"));
            return def;
        }
        int value = this.yaml.getInt(path, def);
        if (value < min) {
            this.errorConsumer.accept(new ConfigError(this.name, path, "value must be at least " + min));
            return def;
        }
        if (value > max) {
            this.errorConsumer.accept(new ConfigError(this.name, path, "value must be at most " + max));
            return def;
        }
        return value;
    }

    public boolean getBoolean(String path, boolean def) {
        return this.getBoolean(path, def, true);
    }

    public boolean getBoolean(String path, boolean def, boolean logError) {
        if (!this.yaml.isBoolean(path)) {
            if (logError) {
                this.errorConsumer.accept(new ConfigError(this.name, path, "value is not a boolean"));
            }
            return def;
        }
        return this.yaml.getBoolean(path, def);
    }

    public <E extends Enum<E>> E getEnum(String path, Enum<E> def) {
        return this.getEnum(path, def, def.getDeclaringClass());
    }

    public <E extends Enum<E>> E getEnum(String path, Class<E> clazz) {
        return this.getEnum(path, null, clazz);
    }

    public <E extends Enum<E>> E getEnum(String path, Enum<E> def, Class<E> clazz) {
        return this.checkEnum(path, this.getString(path, def == null ? null : def.name(), EnumUtils.getValues(clazz)), clazz, def, null);
    }

    public <E extends Enum<E>> List<E> getRegexEnums(String path, Class<E> clazz) {
        List<String> strings = this.getList(path);
        ArrayList<E> enums = new ArrayList<E>(strings.size());
        for (String regex : strings) {
            enums.addAll(EnumUtils.getEnumsByRegex(regex, clazz));
        }
        return enums;
    }

    public <E extends Enum<E>> List<E> getEnums(String path, Class<E> clazz) {
        return this.getEnums(path, clazz, null);
    }

    public <E extends Enum<E>> List<E> getEnums(String path, Class<E> clazz, String friendlyName) {
        List<String> strings = this.getList(path);
        ArrayList<E> enums = new ArrayList<E>(strings.size());
        for (String str : strings) {
            E e = this.checkEnum(path, str, clazz, null, friendlyName);
            if (e == null) continue;
            enums.add(e);
        }
        return enums;
    }

    public <E extends Enum<E>> E checkEnum(String path, String value, Class<E> clazz, Enum<E> def, String friendlyName) {
        String defVal = def == null ? null : def.name();
        String checked = this.checkString(value, defVal, path, EnumUtils.getValues(clazz), friendlyName);
        return checked == null ? null : (E)Enum.valueOf(clazz, checked);
    }

    public String getRawString(String path) {
        String str = this.yaml.getString(path);
        return str == null || str.isEmpty() ? null : str;
    }

    public String getString(String path, String def) {
        return this.getString(path, def, true);
    }

    public String getString(String path, String def, boolean logError) {
        if (!this.yaml.isString(path)) {
            if (logError) {
                this.errorConsumer.accept(new ConfigError(this.name, path, "value is not a string"));
            }
            return def;
        }
        return this.yaml.getString(path, def);
    }

    public String getString(String path, String def, String ... allowedValues) {
        return this.getString(path, def, new HashSet<String>(Arrays.asList(allowedValues)), null);
    }

    public String getString(String path, String def, Set<String> allowedValues) {
        return this.getString(path, def, allowedValues, null);
    }

    public String getString(String path, String def, Set<String> allowedValues, String friendlyName) {
        String value = this.getString(path, null);
        return value == null ? def : this.checkString(value, def, path, allowedValues, friendlyName);
    }

    private String checkString(String value, String def, String path, Set<String> allowedValues, String friendlyName) {
        String upperCased = value.toUpperCase();
        if (!allowedValues.contains(upperCased)) {
            if (friendlyName != null) {
                this.errorConsumer.accept(new ConfigError(this.name, path, "'" + value + "' is not a valid " + friendlyName + "!"));
            } else {
                String values = allowedValues.stream().collect(Collectors.joining(", ", "\"", "\""));
                this.errorConsumer.accept(new ConfigError(this.name, path, "'" + value + "' is not valid, it must be one of " + values + "!"));
            }
            return def;
        }
        return upperCased;
    }

    public Map<String, Set<String>> getMapFromList(String path, String delimiter) {
        return this.getMapFromList(path, delimiter, new HashMap<String, Set<String>>());
    }

    public Map<String, Set<String>> getMapFromList(String path, String delimiter, Map<String, Set<String>> map) {
        for (String str : this.getList(path)) {
            String[] kv = str.split(delimiter, 2);
            if (kv.length == 1) {
                map.put(kv[0], null);
                continue;
            }
            if (kv.length == 2) {
                map.computeIfAbsent(kv[0], k -> new HashSet()).add(kv[1]);
                continue;
            }
            this.errorConsumer.accept(new ConfigError(this.name, path, "invalid key/value pair (" + str + ")"));
        }
        return map;
    }

    public Set<String> getSet(String path) {
        return new HashSet<String>(this.getList(path));
    }

    public Set<String> getSet(String path, Set<String> allowedValues, String friendlyName) {
        return new HashSet<String>(this.getList(path, allowedValues, friendlyName));
    }

    public Set<String> getSet(String path, Set<String> allowedValues, String friendlyName, List<String> list) {
        return new HashSet<String>(this.getList(path, allowedValues, friendlyName, list));
    }

    public List<String> getList(String path) {
        return this.yaml.getStringList(path);
    }

    public List<String> getList(String path, Set<String> allowedValues, String friendlyName) {
        return this.getList(path, allowedValues, friendlyName, new ArrayList<String>());
    }

    public List<String> getList(String path, Set<String> allowedValues, String friendlyName, List<String> list) {
        for (String str : this.yaml.getStringList(path)) {
            String checked = this.checkString(str, null, path, allowedValues, friendlyName);
            if (checked == null) continue;
            list.add(checked);
        }
        return list;
    }
}

