/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.listeners;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.addons.Region;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.concurrent.storage.AddonStorage;
import dev.frankheijden.insights.api.concurrent.storage.ChunkStorage;
import dev.frankheijden.insights.api.concurrent.storage.Distribution;
import dev.frankheijden.insights.api.concurrent.storage.DistributionStorage;
import dev.frankheijden.insights.api.concurrent.storage.Storage;
import dev.frankheijden.insights.api.concurrent.storage.WorldStorage;
import dev.frankheijden.insights.api.config.LimitEnvironment;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.config.limits.LimitInfo;
import dev.frankheijden.insights.api.objects.InsightsBase;
import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.tasks.ScanTask;
import dev.frankheijden.insights.api.utils.ChunkUtils;
import dev.frankheijden.insights.api.utils.StringUtils;
import dev.frankheijden.insights.dependencies.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public abstract class InsightsListener
extends InsightsBase
implements Listener {
    protected InsightsListener(InsightsPlugin plugin) {
        super(plugin);
    }

    protected void handleModification(Block block, int amount) {
        this.handleModification(block.getLocation(), block.getType(), amount);
    }

    protected void handleModification(BlockState state, int amount) {
        this.handleModification(state.getLocation(), state.getType(), amount);
    }

    protected void handleModification(Location location, Material material, int amount) {
        if (amount < 0) {
            this.handleModification(location, material, Material.AIR, -amount);
        } else {
            this.handleModification(location, Material.AIR, material, amount);
        }
    }

    protected void handleModification(Location location, Consumer<Storage> storageConsumer) {
        UUID worldUid = location.getWorld().getUID();
        long chunkKey = ChunkUtils.getKey(location);
        this.plugin.getWorldStorage().getWorld(worldUid).get(chunkKey).ifPresent(storageConsumer);
        this.plugin.getAddonManager().getRegion(location).flatMap(region -> this.plugin.getAddonStorage().get(region.getKey())).ifPresent(storageConsumer);
    }

    protected void handleModification(Location location, Material from, Material to, int amount) {
        this.handleModification(location, storage -> {
            storage.modify(ScanObject.of(from), -amount);
            storage.modify(ScanObject.of(to), amount);
        });
    }

    protected void handleModification(Location location, EntityType entity, int amount) {
        this.handleModification(location, storage -> storage.modify(ScanObject.of(entity), amount));
    }

    protected boolean handleAddition(Player player, Location location, ScanObject<?> item, int delta) {
        return this.handleAddition(player, location, item, delta, true);
    }

    protected boolean handleAddition(Player player, Location location, ScanObject<?> item, int delta, boolean included) {
        LimitEnvironment env;
        String area;
        boolean queued;
        Optional<Region> regionOptional = this.plugin.getAddonManager().getRegion(location);
        Chunk chunk = location.getChunk();
        World world = location.getWorld();
        UUID worldUid = world.getUID();
        long chunkKey = ChunkUtils.getKey(chunk);
        if (regionOptional.isPresent()) {
            Region region = regionOptional.get();
            queued = this.plugin.getAddonScanTracker().isQueued(region.getKey());
            area = this.plugin.getAddonManager().getAddon(region.getAddon()).getAreaName();
            env = new LimitEnvironment(player, world.getName(), region.getAddon());
        } else {
            queued = this.plugin.getWorldChunkScanTracker().isQueued(worldUid, chunkKey);
            area = "chunk";
            env = new LimitEnvironment(player, world.getName());
        }
        if (queued) {
            if (this.plugin.getSettings().canReceiveAreaScanNotifications(player)) {
                this.plugin.getMessages().getMessage(Messages.Key.AREA_SCAN_QUEUED).addTemplates(Messages.tagOf("area", area)).sendTo((CommandSender)player);
            }
            return true;
        }
        Optional<Limit> limitOptional = this.plugin.getLimits().getFirstLimit(item, (Predicate<Limit>)env);
        if (limitOptional.isEmpty()) {
            return false;
        }
        Limit limit = limitOptional.get();
        LimitInfo limitInfo = limit.getLimit(item);
        if (regionOptional.isEmpty() && limit.getSettings().isDisallowedPlacementOutsideRegion()) {
            this.plugin.getMessages().getMessage(Messages.Key.LIMIT_DISALLOWED_PLACEMENT).addTemplates(TagResolver.resolver(Messages.tagOf("name", limitInfo.getName()), Messages.tagOf("area", area))).sendTo((CommandSender)player);
            return true;
        }
        Consumer<Storage> storageConsumer = storage -> {
            if (included && regionOptional.isEmpty()) {
                storage.modify(item, -delta);
            }
            if (this.plugin.getSettings().canReceiveAreaScanNotifications(player)) {
                this.plugin.getMessages().getMessage(Messages.Key.AREA_SCAN_COMPLETED).sendTo((CommandSender)player);
            }
        };
        Optional<Storage> storageOptional = regionOptional.isPresent() ? this.handleAddonAddition(player, regionOptional.get(), storageConsumer) : this.handleChunkAddition(player, chunk, storageConsumer);
        if (storageOptional.isEmpty()) {
            return true;
        }
        Storage storage2 = storageOptional.get();
        long count = storage2.count(limit, item);
        if (count + (long)delta > (long)limitInfo.getLimit()) {
            this.plugin.getMessages().getMessage(Messages.Key.LIMIT_REACHED).addTemplates(Messages.tagOf("limit", StringUtils.pretty(limitInfo.getLimit())), Messages.tagOf("name", limitInfo.getName()), Messages.tagOf("area", area)).sendTo((CommandSender)player);
            return true;
        }
        return false;
    }

    protected void evaluateAddition(Player player, Location location, ScanObject<?> item, int delta) {
        Optional<Storage> storageOptional;
        LimitEnvironment env;
        Optional<Region> regionOptional = this.plugin.getAddonManager().getRegion(location);
        World world = location.getWorld();
        long chunkKey = ChunkUtils.getKey(location);
        if (regionOptional.isPresent()) {
            Region region = regionOptional.get();
            env = new LimitEnvironment(player, world.getName(), region.getAddon());
            storageOptional = this.plugin.getAddonStorage().get(region.getKey());
        } else {
            env = new LimitEnvironment(player, world.getName());
            storageOptional = this.plugin.getWorldStorage().getWorld(world.getUID()).get(chunkKey);
        }
        if (storageOptional.isEmpty()) {
            return;
        }
        Storage storage = storageOptional.get();
        Optional<Limit> limitOptional = this.plugin.getLimits().getFirstLimit(item, (Predicate<Limit>)env);
        if (limitOptional.isEmpty()) {
            return;
        }
        Limit limit = limitOptional.get();
        LimitInfo limitInfo = limit.getLimit(item);
        long count = storage.count(limit, item);
        if (player.hasPermission("insights.notifications")) {
            float progress = (float)(count + (long)delta) / (float)limitInfo.getLimit();
            this.plugin.getNotifications().getCachedProgress(player.getUniqueId(), Messages.Key.LIMIT_NOTIFICATION).progress(progress).add(player).create().addTemplates(Messages.tagOf("name", limitInfo.getName()), Messages.tagOf("count", StringUtils.pretty(count + (long)delta)), Messages.tagOf("limit", StringUtils.pretty(limitInfo.getLimit()))).send();
        }
    }

    private Optional<Storage> handleChunkAddition(Player player, Chunk chunk, Consumer<Storage> storageConsumer) {
        UUID worldUid = chunk.getWorld().getUID();
        long chunkKey = ChunkUtils.getKey(chunk);
        WorldStorage worldStorage = this.plugin.getWorldStorage();
        ChunkStorage chunkStorage = worldStorage.getWorld(worldUid);
        Optional<Storage> storageOptional = chunkStorage.get(chunkKey);
        if (storageOptional.isEmpty()) {
            if (this.plugin.getSettings().canReceiveAreaScanNotifications(player)) {
                this.plugin.getMessages().getMessage(Messages.Key.AREA_SCAN_STARTED).addTemplates(Messages.tagOf("area", "chunk")).sendTo((CommandSender)player);
            }
            ((CompletableFuture)this.plugin.getChunkContainerExecutor().submit(chunk).thenAccept((Consumer)storageConsumer)).exceptionally(th -> {
                this.plugin.getLogger().log(Level.SEVERE, (Throwable)th, th::getMessage);
                return null;
            });
        }
        return storageOptional;
    }

    private Optional<Storage> handleAddonAddition(Player player, Region region, Consumer<Storage> storageConsumer) {
        String key = region.getKey();
        AddonStorage addonStorage = this.plugin.getAddonStorage();
        Optional<Storage> storageOptional = addonStorage.get(key);
        if (storageOptional.isEmpty()) {
            if (this.plugin.getSettings().canReceiveAreaScanNotifications(player)) {
                this.plugin.getMessages().getMessage(Messages.Key.AREA_SCAN_STARTED).addTemplates(Messages.tagOf("area", this.plugin.getAddonManager().getAddon(region.getAddon()).getAreaName())).sendTo((CommandSender)player);
            }
            this.scanRegion(player, region, storageConsumer);
            return Optional.empty();
        }
        return storageOptional;
    }

    protected void handleRemoval(Player player, Location location, ScanObject<?> item, int delta) {
        this.handleRemoval(player, location, item, delta, true);
    }

    protected void handleRemoval(Player player, Location location, ScanObject<?> item, int delta, boolean included) {
        Optional<Storage> storageOptional;
        LimitEnvironment env;
        boolean queued;
        Optional<Region> regionOptional = this.plugin.getAddonManager().getRegion(location);
        Chunk chunk = location.getChunk();
        World world = location.getWorld();
        UUID worldUid = world.getUID();
        long chunkKey = ChunkUtils.getKey(chunk);
        UUID uuid = player.getUniqueId();
        if (regionOptional.isPresent()) {
            Region region = regionOptional.get();
            queued = this.plugin.getAddonScanTracker().isQueued(region.getKey());
            env = new LimitEnvironment(player, world.getName(), region.getAddon());
            storageOptional = this.plugin.getAddonStorage().get(region.getKey());
        } else {
            queued = this.plugin.getWorldChunkScanTracker().isQueued(worldUid, chunkKey);
            env = new LimitEnvironment(player, world.getName());
            storageOptional = this.plugin.getWorldStorage().getWorld(worldUid).get(chunkKey);
        }
        storageOptional.ifPresent(storage -> storage.modify(item, -delta));
        if (player.hasPermission("insights.notifications")) {
            if (queued) {
                return;
            }
            Optional<Limit> limitOptional = this.plugin.getLimits().getFirstLimit(item, (Predicate<Limit>)env);
            if (limitOptional.isEmpty()) {
                return;
            }
            Limit limit = limitOptional.get();
            LimitInfo limitInfo = limit.getLimit(item);
            Consumer<Storage> notification = storage -> {
                long count = storage.count(limit, item);
                float progress = (float)count / (float)limitInfo.getLimit();
                this.plugin.getNotifications().getCachedProgress(uuid, Messages.Key.LIMIT_NOTIFICATION).progress(progress).add(player).create().addTemplates(Messages.tagOf("name", limitInfo.getName()), Messages.tagOf("count", StringUtils.pretty(count)), Messages.tagOf("limit", StringUtils.pretty(limitInfo.getLimit()))).send();
            };
            if (storageOptional.isPresent()) {
                notification.accept(storageOptional.get());
                return;
            }
            Consumer<Storage> storageConsumer = storage -> {
                if (included && regionOptional.isEmpty()) {
                    storage.modify(item, -delta);
                }
                notification.accept((Storage)storage);
            };
            if (regionOptional.isPresent()) {
                this.scanRegion(player, regionOptional.get(), storageConsumer);
            } else {
                ((CompletableFuture)this.plugin.getChunkContainerExecutor().submit(chunk).thenAccept((Consumer)storageConsumer)).exceptionally(th -> {
                    this.plugin.getLogger().log(Level.SEVERE, (Throwable)th, th::getMessage);
                    return null;
                });
            }
        }
    }

    private void scanRegion(Player player, Region region, Consumer<Storage> storageConsumer) {
        this.plugin.getAddonScanTracker().add(region.getAddon());
        List<ChunkPart> chunkParts = region.toChunkParts();
        ScanTask.scan(this.plugin, player, chunkParts, chunkParts.size(), ScanOptions.scanOnly(), player.hasPermission("insights.notifications"), DistributionStorage::new, (storage, loc, acc) -> storage.mergeRight((Distribution<ScanObject<?>>)acc), storage -> {
            this.plugin.getAddonScanTracker().remove(region.getAddon());
            this.plugin.getAddonStorage().put(region.getKey(), (Storage)storage);
            storageConsumer.accept((Storage)storage);
        });
    }
}

