/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.objects.chunk;

import dev.frankheijden.insights.api.objects.chunk.ChunkVector;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.World;

public class ChunkCuboid {
    private static final Map<UUID, ChunkCuboid> maxCuboidCache = new HashMap<UUID, ChunkCuboid>();
    private final ChunkVector min;
    private final ChunkVector max;

    public ChunkCuboid(ChunkVector min, ChunkVector max) {
        this.min = min;
        this.max = max;
    }

    public ChunkVector getMin() {
        return this.min;
    }

    public ChunkVector getMax() {
        return this.max;
    }

    public long getVolume() {
        return ((long)(this.max.getX() - this.min.getX()) + 1L) * ((long)(this.max.getY() - this.min.getY()) + 1L) * ((long)(this.max.getX() - this.min.getZ()) + 1L);
    }

    public boolean contains(ChunkCuboid other) {
        return this.min.getX() <= other.min.getX() && this.min.getY() <= other.min.getY() && this.min.getZ() <= other.min.getZ() && this.max.getX() >= other.max.getX() && this.max.getY() >= other.max.getY() && this.max.getZ() >= other.max.getZ();
    }

    public static ChunkCuboid maxCuboid(World world) {
        return maxCuboidCache.computeIfAbsent(world.getUID(), k -> new ChunkCuboid(ChunkVector.minVector(world), ChunkVector.maxVector(world)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkCuboid that = (ChunkCuboid)o;
        return this.min.equals(that.min) && this.max.equals(that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return String.valueOf(this.min) + " -> " + String.valueOf(this.max);
    }
}

