/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.objects.chunk;

import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import dev.frankheijden.insights.api.utils.ChunkUtils;
import java.util.Objects;
import org.bukkit.Chunk;
import org.bukkit.World;

public class ChunkLocation {
    private final World world;
    private final int x;
    private final int z;

    public ChunkLocation(World world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public static ChunkLocation of(Chunk chunk) {
        return new ChunkLocation(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public long getKey() {
        return ChunkUtils.getKey(this.x, this.z);
    }

    public ChunkPart toPart() {
        return new ChunkPart(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkLocation that = (ChunkLocation)o;
        return this.x == that.x && this.z == that.z && this.world.equals((Object)that.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }

    public String toString() {
        return this.world.getName() + " @ " + this.x + ", " + this.z;
    }
}

