/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.objects.chunk;

import dev.frankheijden.insights.api.objects.math.Vector3;
import org.bukkit.World;

public class ChunkVector
extends Vector3 {
    public ChunkVector(int x, int y, int z) {
        super(x, y, z);
    }

    public static ChunkVector from(Vector3 vector) {
        return new ChunkVector(vector.getX() & 0xF, vector.getY(), vector.getZ() & 0xF);
    }

    public static ChunkVector minVector(World world) {
        return new ChunkVector(0, world.getMinHeight(), 0);
    }

    public static ChunkVector maxVector(World world) {
        return new ChunkVector(15, world.getMaxHeight() - 1, 15);
    }

    public ChunkVector min(ChunkVector other) {
        return new ChunkVector(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z));
    }

    public ChunkVector max(ChunkVector other) {
        return new ChunkVector(Math.max(this.x, other.x), Math.max(this.y, other.y), Math.max(this.z, other.z));
    }
}

