/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.objects.wrappers;

import dev.frankheijden.insights.api.utils.Constants;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public abstract class ScanObject<T extends Enum<T>> {
    private static final Map<Material, MaterialObject> materialMap = new EnumMap<Material, MaterialObject>(Material.class);
    private static final Map<EntityType, EntityObject> entityMap = new EnumMap<EntityType, EntityObject>(EntityType.class);
    private final T object;
    private final Type type;

    protected ScanObject(T object, Type type) {
        this.object = object;
        this.type = type;
    }

    public static MaterialObject of(Material material) {
        return materialMap.get(material);
    }

    public static EntityObject of(EntityType entityType) {
        return entityMap.get(entityType);
    }

    public static ScanObject<?> of(Object item) {
        if (item instanceof Material) {
            return ScanObject.of((Material)item);
        }
        if (item instanceof EntityType) {
            return ScanObject.of((EntityType)item);
        }
        throw new IllegalArgumentException("Unknown ScanObject of type " + String.valueOf(item.getClass()));
    }

    public static Set<ScanObject<?>> of(Collection<? extends Object> items) {
        HashSet scanObjects = new HashSet(items.size());
        for (Object object : items) {
            scanObjects.add(ScanObject.of(object));
        }
        return scanObjects;
    }

    public static Set<ScanObject<?>> of(Collection<? extends Material> materials, Collection<? extends EntityType> entities) {
        HashSet scanObjects = new HashSet(materials.size() + entities.size());
        for (Material material : materials) {
            scanObjects.add(ScanObject.of(material));
        }
        for (EntityType entityType : entities) {
            scanObjects.add(ScanObject.of(entityType));
        }
        return scanObjects;
    }

    public static ScanObject<?> parse(String str) {
        String upperCased = str.toUpperCase(Locale.ENGLISH);
        try {
            Material material = Material.valueOf((String)upperCased);
            if (Constants.BLOCKS.contains(material)) {
                return ScanObject.of(material);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            return ScanObject.of(EntityType.valueOf((String)upperCased));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unknown ScanObject '" + str + "'");
        }
    }

    public T getObject() {
        return this.object;
    }

    public Type getType() {
        return this.type;
    }

    public String name() {
        return ((Enum)this.object).name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanObject that = (ScanObject)o;
        return ((Enum)this.object).equals(that.object) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.object, this.type});
    }

    static {
        for (Material material : Material.values()) {
            materialMap.put(material, new MaterialObject(material));
        }
        for (Material material : EntityType.values()) {
            entityMap.put((EntityType)material, new EntityObject((EntityType)material));
        }
    }

    public static enum Type {
        MATERIAL,
        ENTITY;

    }

    public static final class MaterialObject
    extends ScanObject<Material> {
        protected MaterialObject(Material object) {
            super(object, Type.MATERIAL);
        }
    }

    public static final class EntityObject
    extends ScanObject<EntityType> {
        protected EntityObject(EntityType object) {
            super(object, Type.ENTITY);
        }
    }
}

