/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.reflection;

import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.util.SetCollector;
import dev.frankheijden.insights.nms.core.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;

public class RTileEntityTypes {
    private static final Set<Material> TILE_ENTITY_MATERIALS;
    private static final Set<ScanObject.MaterialObject> TILE_ENTITIES;

    private RTileEntityTypes() {
    }

    public static boolean isTileEntity(Material m) {
        return TILE_ENTITY_MATERIALS.contains(m);
    }

    public static Set<Material> getTileEntityMaterials() {
        return TILE_ENTITY_MATERIALS;
    }

    public static Set<ScanObject.MaterialObject> getTileEntities() {
        return TILE_ENTITIES;
    }

    static {
        try {
            MethodHandle isValidMethodHandle;
            Class<?> tileEntityTypesClazz = Class.forName("net.minecraft.world.level.block.entity.BlockEntityType");
            Class<?> craftBlockDataClazz = Class.forName("org.bukkit.craftbukkit.block.data.CraftBlockData");
            Class<?> blockDataClazz = Class.forName("net.minecraft.world.level.block.state.BlockState");
            try {
                isValidMethodHandle = MethodHandles.lookup().unreflect(ReflectionUtils.findDeclaredMethod(tileEntityTypesClazz, new Class[]{blockDataClazz}, Boolean.TYPE, "isValid"));
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            EnumMap<Material, Object> blockStateMap = new EnumMap<Material, Object>(Material.class);
            for (Material m : Material.values()) {
                if (!m.isBlock()) continue;
                blockStateMap.put(m, craftBlockDataClazz.getMethod("getState", new Class[0]).invoke((Object)Bukkit.createBlockData((Material)m), new Object[0]));
            }
            HashSet<Material> materials = new HashSet<Material>();
            try {
                for (Field field : tileEntityTypesClazz.getFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(tileEntityTypesClazz)) continue;
                    Object tileEntityTypes = field.get(null);
                    for (Map.Entry entry : blockStateMap.entrySet()) {
                        if (!isValidMethodHandle.invoke(tileEntityTypes, entry.getValue())) continue;
                        materials.add((Material)entry.getKey());
                    }
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            materials.removeIf(Material::isAir);
            TILE_ENTITY_MATERIALS = Collections.unmodifiableSet(EnumSet.copyOf(materials));
            TILE_ENTITIES = (Set)TILE_ENTITY_MATERIALS.stream().map(ScanObject::of).collect(SetCollector.unmodifiableSet());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

