/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.tasks;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.concurrent.ChunkContainerExecutor;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.concurrent.storage.Distribution;
import dev.frankheijden.insights.api.concurrent.storage.DistributionStorage;
import dev.frankheijden.insights.api.concurrent.storage.Storage;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.config.notifications.ProgressNotification;
import dev.frankheijden.insights.api.objects.chunk.ChunkLocation;
import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.util.TriConsumer;
import dev.frankheijden.insights.api.utils.EnumUtils;
import dev.frankheijden.insights.api.utils.StringUtils;
import dev.frankheijden.insights.dependencies.adventure.text.Component;
import java.time.Duration;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class ScanTask<R>
implements Runnable {
    private static final Map<UUID, ScanTask<?>> scanners = new ConcurrentHashMap();
    private final InsightsPlugin plugin;
    private final ChunkContainerExecutor executor;
    private final Iterator<? extends ChunkPart> scanQueue;
    private final ScanOptions options;
    private final int chunksPerIteration;
    private final Consumer<Info> infoConsumer;
    private final long infoTimeout;
    private final R result;
    private final TriConsumer<Storage, ChunkLocation, R> resultMerger;
    private final Consumer<R> resultConsumer;
    private final AtomicInteger iterationChunks;
    private final AtomicInteger chunks = new AtomicInteger(0);
    private final AtomicBoolean completedExceptionally = new AtomicBoolean();
    private final int chunkCount;
    private long lastInfo = 0L;
    private BukkitTask task;

    private ScanTask(InsightsPlugin plugin, Iterable<? extends ChunkPart> chunkParts, int chunkCount, ScanOptions options, int chunksPerIteration, Consumer<Info> infoConsumer, long infoTimeoutMillis, Supplier<R> resultSupplier, TriConsumer<Storage, ChunkLocation, R> resultMerger, Consumer<R> resultConsumer) {
        this.plugin = plugin;
        this.executor = plugin.getChunkContainerExecutor();
        this.scanQueue = chunkParts.iterator();
        this.options = options;
        this.chunksPerIteration = chunksPerIteration;
        this.infoConsumer = infoConsumer;
        this.infoTimeout = infoTimeoutMillis * 1000000L;
        this.result = resultSupplier.get();
        this.resultMerger = resultMerger;
        this.resultConsumer = resultConsumer;
        this.iterationChunks = new AtomicInteger(chunksPerIteration);
        this.chunkCount = chunkCount;
    }

    public static void scan(InsightsPlugin plugin, Iterable<? extends ChunkPart> chunkParts, int chunkCount, ScanOptions options, Consumer<Info> infoConsumer, Consumer<DistributionStorage> distributionConsumer) {
        new ScanTask<DistributionStorage>(plugin, chunkParts, chunkCount, options, plugin.getSettings().SCANS_CHUNKS_PER_ITERATION, infoConsumer, plugin.getSettings().SCANS_INFO_INTERVAL_MILLIS, DistributionStorage::new, (storage, loc, acc) -> storage.mergeRight((Distribution<ScanObject<?>>)acc), distributionConsumer).start();
    }

    public static <R> ScanTask<R> scan(InsightsPlugin plugin, Player player, Iterable<? extends ChunkPart> chunkParts, int chunkCount, ScanOptions options, boolean notify, Supplier<R> resultSupplier, TriConsumer<Storage, ChunkLocation, R> resultMerger, Consumer<R> resultConsumer) {
        ProgressNotification notification = plugin.getNotifications().getCachedProgress(player.getUniqueId(), Messages.Key.SCAN_PROGRESS);
        if (notify) {
            notification.add(player);
        }
        ScanTask<R> task = new ScanTask<R>(plugin, chunkParts, chunkCount, options, plugin.getSettings().SCANS_CHUNKS_PER_ITERATION, info -> {
            if (!notify) {
                return;
            }
            float progress = (float)info.getChunksDone() / (float)info.getChunks();
            notification.progress(progress).create().addTemplates(Messages.tagOf("percentage", StringUtils.prettyOneDecimal(progress * 100.0f)), Messages.tagOf("count", StringUtils.pretty(info.getChunksDone())), Messages.tagOf("total", StringUtils.pretty(info.getChunks()))).send();
        }, plugin.getSettings().SCANS_INFO_INTERVAL_MILLIS, resultSupplier, resultMerger, resultConsumer);
        task.start();
        return task;
    }

    public static void scanAndDisplay(InsightsPlugin plugin, Player player, Iterable<? extends ChunkPart> chunkParts, int chunkCount, ScanOptions options, Set<? extends ScanObject<?>> items, boolean displayZeros) {
        long start = System.nanoTime();
        ScanTask.scanAndDisplay(plugin, player, chunkParts, chunkCount, options, DistributionStorage::new, (storage, loc, acc) -> storage.mergeRight((Distribution<ScanObject<?>>)acc), storage -> {
            long millis = (System.nanoTime() - start) / 1000000L;
            Messages messages = plugin.getMessages();
            ScanObject[] displayItems = (ScanObject[])(items == null ? storage.keys() : items).stream().filter(item -> storage.count(item) != 0L || displayZeros).sorted(Comparator.comparing(ScanObject::name)).toArray(ScanObject[]::new);
            Messages.Message footer = messages.getMessage(Messages.Key.SCAN_FINISH_FOOTER).addTemplates(Messages.tagOf("chunks", StringUtils.pretty(chunkCount)), Messages.tagOf("blocks", StringUtils.pretty(storage.count(s -> s.getType() == ScanObject.Type.MATERIAL))), Messages.tagOf("entities", StringUtils.pretty(storage.count(s -> s.getType() == ScanObject.Type.ENTITY))), Messages.tagOf("time", StringUtils.pretty(Duration.ofMillis(millis))));
            Messages.PaginatedMessage<ScanObject> message = messages.createPaginatedMessage(messages.getMessage(Messages.Key.SCAN_FINISH_HEADER), Messages.Key.SCAN_FINISH_FORMAT, footer, displayItems, storage::count, item -> Component.text(EnumUtils.pretty(item.getObject())));
            plugin.getScanHistory().setHistory(player.getUniqueId(), message);
            message.sendTo((CommandSender)player, 0);
        });
    }

    public static <R> void scanAndDisplay(InsightsPlugin plugin, Player player, Iterable<? extends ChunkPart> chunkParts, int chunkCount, ScanOptions options, Supplier<R> resultSupplier, TriConsumer<Storage, ChunkLocation, R> resultMerger, Consumer<R> resultConsumer) {
        UUID uuid = player.getUniqueId();
        if (scanners.containsKey(uuid)) {
            plugin.getMessages().getMessage(Messages.Key.SCAN_ALREADY_SCANNING).sendTo((CommandSender)player);
            return;
        }
        plugin.getMessages().getMessage(Messages.Key.SCAN_START).addTemplates(Messages.tagOf("count", StringUtils.pretty(chunkCount))).sendTo((CommandSender)player);
        ScanTask<Object> task = ScanTask.scan(plugin, player, chunkParts, chunkCount, options, true, resultSupplier, resultMerger, resultConsumer.andThen(r -> scanners.remove(uuid)));
        scanners.put(uuid, task);
    }

    public static boolean cancelScan(UUID uuid) {
        ScanTask<?> scanTask = scanners.remove(uuid);
        if (scanTask == null) {
            return false;
        }
        scanTask.cancel();
        return true;
    }

    public static void scanAndDisplayGroupedByChunk(InsightsPlugin plugin, Player player, Iterable<? extends ChunkPart> chunkParts, int chunkCount, ScanOptions options, Set<? extends ScanObject<?>> items, boolean displayZeros) {
        long start = System.nanoTime();
        ScanTask.scanAndDisplay(plugin, player, chunkParts, chunkCount, options, ConcurrentHashMap::new, (storage, loc, map) -> map.put(loc, storage), map -> {
            long millis = (System.nanoTime() - start) / 1000000L;
            Messages messages = plugin.getMessages();
            ChunkLocation[] keys = (ChunkLocation[])map.entrySet().stream().filter(entry -> {
                Storage storage = (Storage)entry.getValue();
                return displayZeros || storage.count(items == null ? storage.keys() : items) != 0L;
            }).sorted(Comparator.comparingLong(entry -> {
                Storage storage = (Storage)entry.getValue();
                return storage.count(items == null ? storage.keys() : items);
            }).reversed()).map(Map.Entry::getKey).toArray(ChunkLocation[]::new);
            long blockCount = map.values().stream().mapToLong(storage -> storage.count(i -> i.getType() == ScanObject.Type.MATERIAL)).sum();
            long entityCount = map.values().stream().mapToLong(storage -> storage.count(i -> i.getType() == ScanObject.Type.ENTITY)).sum();
            Messages.Message footer = messages.getMessage(Messages.Key.SCAN_FINISH_FOOTER).addTemplates(Messages.tagOf("chunks", StringUtils.pretty(chunkCount)), Messages.tagOf("blocks", StringUtils.pretty(blockCount)), Messages.tagOf("entities", StringUtils.pretty(entityCount)), Messages.tagOf("time", StringUtils.pretty(Duration.ofMillis(millis))));
            Messages.PaginatedMessage<ChunkLocation> message = messages.createPaginatedMessage(messages.getMessage(Messages.Key.SCAN_FINISH_HEADER), Messages.Key.SCAN_FINISH_FORMAT, footer, keys, key -> {
                Storage storage = (Storage)map.get(key);
                return storage.count(items == null ? storage.keys() : items);
            }, key -> {
                String worldName = key.getWorld().getName();
                String x = Integer.toString(key.getX());
                String z = Integer.toString(key.getZ());
                return messages.getMessage(Messages.Key.SCAN_FINISH_CHUNK_FORMAT).addTemplates(Messages.tagOf("world", worldName), Messages.tagOf("chunk-x", x), Messages.tagOf("chunk-z", z)).toComponent().orElse(Component.text(worldName + " @ " + x + ", " + z));
            });
            plugin.getScanHistory().setHistory(player.getUniqueId(), message);
            message.sendTo((CommandSender)player, 0);
        });
    }

    private void start() {
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        this.task = scheduler.runTaskTimer((Plugin)this.plugin, (Runnable)this, 0L, (long)this.plugin.getSettings().SCANS_ITERATION_INTERVAL_TICKS);
    }

    private void cancel() {
        if (this.task != null) {
            this.task.cancel();
            if (this.completedExceptionally.get()) {
                this.resultConsumer.accept(null);
            } else {
                this.sendInfo();
                this.resultConsumer.accept(this.result);
            }
        }
    }

    @Override
    public void run() {
        this.checkNotify();
        if (this.chunks.get() == this.chunkCount || this.completedExceptionally.get()) {
            this.cancel();
            return;
        }
        int previouslyDone = this.iterationChunks.get();
        int chunkIterations = Math.min(previouslyDone, this.chunksPerIteration);
        if (chunkIterations == 0) {
            return;
        }
        this.iterationChunks.addAndGet(-chunkIterations);
        for (int i = 0; i < chunkIterations && this.scanQueue.hasNext(); ++i) {
            ChunkPart chunkPart = this.scanQueue.next();
            ChunkLocation loc = chunkPart.getChunkLocation();
            World world = loc.getWorld();
            CompletableFuture<Storage> storageFuture = world.isChunkLoaded(loc.getX(), loc.getZ()) ? this.executor.submit(world.getChunkAt(loc.getX(), loc.getZ()), chunkPart.getChunkCuboid(), this.options) : this.executor.submit(loc.getWorld(), loc.getX(), loc.getZ(), chunkPart.getChunkCuboid(), this.options);
            ((CompletableFuture)((CompletableFuture)storageFuture.thenAccept(storage -> this.resultMerger.accept((Storage)storage, loc, this.result))).thenRun(() -> {
                this.iterationChunks.incrementAndGet();
                this.chunks.incrementAndGet();
            })).exceptionally(th -> {
                if (!this.completedExceptionally.getAndSet(true)) {
                    this.plugin.getLogger().log(Level.SEVERE, (Throwable)th, th::getMessage);
                }
                return null;
            });
        }
    }

    private void checkNotify() {
        long now = System.nanoTime();
        if (this.lastInfo + this.infoTimeout < now) {
            this.lastInfo = now;
            ForkJoinPool.commonPool().execute(this::sendInfo);
        }
    }

    private void sendInfo() {
        this.infoConsumer.accept(new Info(this.chunks.get(), this.chunkCount));
    }

    public static final class Info {
        private final int chunksDone;
        private final int chunks;

        public Info(int chunksDone, int chunks) {
            this.chunksDone = chunksDone;
            this.chunks = chunks;
        }

        public int getChunksDone() {
            return this.chunksDone;
        }

        public int getChunks() {
            return this.chunks;
        }
    }
}

