/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.tasks;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.tasks.InsightsAsyncTask;
import dev.frankheijden.insights.api.utils.VersionUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;

public class UpdateCheckerTask
extends InsightsAsyncTask {
    private static final URL GITHUB_LINK;
    private static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:77.0) Gecko/20100101 Firefox/77.0";
    private static final String UPDATE_CHECK_START = "Checking for updates...";
    private static final String RATE_LIMIT = "Received ratelimit from GitHub.";
    private static final String GENERAL_ERROR = "Error fetching new version of Insights: {0}";
    private static final String TRY_LATER = "Error fetching new version of Insights, please try again later!";
    private static final String CONNECTION_ERROR = "Error fetching new version of Insights: {0}: ({0}) {1} (maybe check your connection?)";
    private static final String UNAVAILABLE = "Error fetching new version of Insights: {0}: ({0}) {1} (no update available)";
    private static final String UPDATE_AVAILABLE = "Insights {0} is available!";
    private static final String RELEASE_INFO = "Release info: {0}";
    private static final String UP_TO_DATE = "We are up-to-date!";
    private static Update cachedUpdate;

    public UpdateCheckerTask(InsightsPlugin plugin) {
        super(plugin);
    }

    public static void check(CommandSender sender) {
        Messages messages = InsightsPlugin.getInstance().getMessages();
        UpdateCheckerTask.getCachedUpdate().ifPresent(update -> messages.getMessage(Messages.Key.UPDATE_AVAILABLE).addTemplates(Messages.tagOf("version", update.version), Messages.tagOf("body", update.body)).sendTo(sender));
    }

    public static Optional<Update> getCachedUpdate() {
        return Optional.ofNullable(cachedUpdate);
    }

    @Override
    public void run() {
        this.plugin.getLogger().info(UPDATE_CHECK_START);
        try {
            JsonObject json;
            InputStream in;
            int code;
            HttpURLConnection conn;
            try {
                conn = (HttpURLConnection)GITHUB_LINK.openConnection();
                conn.setRequestProperty("User-Agent", USER_AGENT);
                conn.setConnectTimeout(10000);
                code = conn.getResponseCode();
            }
            catch (ConnectException | SocketTimeoutException | UnknownHostException ex) {
                this.plugin.getLogger().log(Level.SEVERE, CONNECTION_ERROR, new Object[]{ex.getClass().getSimpleName(), ex.getMessage()});
                return;
            }
            catch (FileNotFoundException ex) {
                this.plugin.getLogger().log(Level.SEVERE, UNAVAILABLE, new Object[]{ex.getClass().getSimpleName(), ex.getMessage()});
                return;
            }
            if (conn.getHeaderFieldInt("x-ratelimit-remaining", 60) == 0) {
                this.plugin.getLogger().warning(RATE_LIMIT);
                return;
            }
            boolean error = code < 200 || code >= 300;
            InputStream inputStream = in = error ? conn.getErrorStream() : conn.getInputStream();
            if (in == null) {
                this.plugin.getLogger().warning(TRY_LATER);
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            if (error) {
                if (json.has("message")) {
                    this.plugin.getLogger().warning(json.get("message").getAsString());
                }
                return;
            }
            String version = json.getAsJsonPrimitive("tag_name").getAsString().replace("v", "").split("-")[0];
            String body = json.getAsJsonPrimitive("body").getAsString();
            if (VersionUtils.isNewVersion(this.plugin.getDescription().getVersion(), version)) {
                this.plugin.getLogger().log(Level.INFO, UPDATE_AVAILABLE, version);
                this.plugin.getLogger().log(Level.INFO, RELEASE_INFO, body);
                cachedUpdate = new Update(version, body);
            } else {
                this.plugin.getLogger().info(UP_TO_DATE);
            }
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, GENERAL_ERROR, ex.getMessage());
        }
    }

    static {
        URL githubLink = null;
        try {
            githubLink = new URL("https://api.github.com/repos/InsightsPlugin/Insights/releases/latest");
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        GITHUB_LINK = githubLink;
        cachedUpdate = null;
    }

    public static class Update {
        private final String version;
        private final String body;

        public Update(String version, String body) {
            this.version = version;
            this.body = body;
        }

        public String getVersion() {
            return this.version;
        }

        public String getBody() {
            return this.body;
        }
    }
}

