/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.util;

import dev.frankheijden.insights.api.objects.chunk.ChunkLocation;
import dev.frankheijden.insights.api.objects.chunk.ChunkPart;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.World;

public class LazyChunkPartRadiusIterator
implements Iterator<ChunkPart>,
Iterable<ChunkPart> {
    private static final EnumMap<Direction, Direction> nextDirections = new EnumMap<Direction, Direction>(Map.of(Direction.NORTH, Direction.EAST, Direction.EAST, Direction.SOUTH, Direction.SOUTH, Direction.WEST, Direction.WEST, Direction.NORTH));
    private final World world;
    private final int chunkCount;
    private int currentChunkCount;
    private int currentChunkX;
    private int currentChunkZ;
    private Direction currentDirection;
    private int currentEdge;
    private int currentEdgeStep;
    private int currentEdgeStepMax;

    public LazyChunkPartRadiusIterator(World world, int chunkX, int chunkZ, int radius) {
        this.world = world;
        int edge = 2 * radius + 1;
        this.chunkCount = edge * edge;
        this.currentChunkCount = 0;
        this.currentChunkX = chunkX;
        this.currentChunkZ = chunkZ;
        this.currentDirection = Direction.NORTH;
        this.currentEdge = 0;
        this.currentEdgeStep = 0;
        this.currentEdgeStepMax = 1;
    }

    @Override
    public boolean hasNext() {
        return this.currentChunkCount < this.chunkCount;
    }

    @Override
    public ChunkPart next() {
        ChunkPart part = new ChunkLocation(this.world, this.currentChunkX, this.currentChunkZ).toPart();
        ++this.currentChunkCount;
        this.currentChunkX += (switch (this.currentDirection.ordinal()) {
            case 1 -> 1;
            case 3 -> -1;
            default -> 0;
        });
        this.currentChunkZ += (switch (this.currentDirection.ordinal()) {
            case 0 -> 1;
            case 2 -> -1;
            default -> 0;
        });
        if (++this.currentEdgeStep >= this.currentEdgeStepMax) {
            this.currentEdgeStep = 0;
            this.currentDirection = nextDirections.get((Object)this.currentDirection);
            if (++this.currentEdge == 2) {
                this.currentEdge = 0;
                ++this.currentEdgeStepMax;
            }
        }
        return part;
    }

    @Override
    public Iterator<ChunkPart> iterator() {
        return this;
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    static enum Direction {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

