/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface SetCollector<T>
extends Collector<T, Set<T>, Set<T>> {
    public static final Set<Collector.Characteristics> defaultCharacteristics = new HashSet<Collector.Characteristics>(Arrays.asList(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));

    public static <T> SetCollector<T> unmodifiableSet() {
        return new SetCollector<T>(){

            @Override
            public Set<T> supplySet() {
                return new HashSet();
            }

            @Override
            public Function<Set<T>, Set<T>> finisher() {
                return Collections::unmodifiableSet;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Collections.singleton(Collector.Characteristics.UNORDERED);
            }
        };
    }

    public Set<T> supplySet();

    @Override
    default public Supplier<Set<T>> supplier() {
        return this::supplySet;
    }

    @Override
    default public BiConsumer<Set<T>, T> accumulator() {
        return Set::add;
    }

    @Override
    default public BinaryOperator<Set<T>> combiner() {
        return (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        };
    }

    @Override
    default public Function<Set<T>, Set<T>> finisher() {
        return Function.identity();
    }

    @Override
    default public Set<Collector.Characteristics> characteristics() {
        return defaultCharacteristics;
    }
}

