/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.utils;

import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;

public class ChunkUtils {
    private ChunkUtils() {
    }

    public static int getX(long key) {
        return (int)(key & 0xFFFFFFFFL);
    }

    public static int getZ(long key) {
        return (int)(key >>> 32 & 0xFFFFFFFFL);
    }

    public static long getKey(Chunk chunk) {
        return ChunkUtils.getKey(chunk.getX(), chunk.getZ());
    }

    public static long getKey(Location location) {
        return ChunkUtils.getKey(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public static long getKey(ChunkSnapshot snapshot) {
        return ChunkUtils.getKey(snapshot.getX(), snapshot.getZ());
    }

    public static long getKey(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }
}

