/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.utils;

import dev.frankheijden.insights.api.utils.SetUtils;
import dev.frankheijden.insights.api.utils.StringUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EnumUtils {
    private EnumUtils() {
    }

    public static <E extends Enum<E>> Set<String> getValues(Class<E> enumClass) {
        return EnumUtils.getValues((Enum[])enumClass.getEnumConstants());
    }

    public static <E extends Enum<E>> Set<String> getValues(Enum<E>[] enums) {
        HashSet<String> values = new HashSet<String>();
        for (Enum<E> e : enums) {
            values.add(e.name());
        }
        return Collections.unmodifiableSet(values);
    }

    public static <E extends Enum<E>> List<E> getEnumsByRegex(String regex, Class<E> enumClass) {
        Pattern pattern = Pattern.compile(regex);
        return EnumUtils.getValues(enumClass).stream().filter(str -> pattern.matcher((CharSequence)str).matches()).map(str -> Enum.valueOf(enumClass, str)).collect(Collectors.toList());
    }

    public static <E extends Enum<E>> String pretty(Enum<E> e) {
        return StringUtils.capitalizeSentence(e.name().replace('_', ' ').toLowerCase(Locale.ENGLISH));
    }

    public static <E extends Enum<E>> Set<E> difference(Set<E> left, Set<E> right) {
        return EnumSet.copyOf(SetUtils.difference(left, right));
    }
}

