/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;

public class IOUtils {
    private IOUtils() {
    }

    public static void copyResources(Path target, ClassLoader loader, Collection<? extends String> collection) {
        try {
            for (String string : collection) {
                InputStream in = IOUtils.getResource(string, loader);
                try {
                    if (in == null) continue;
                    IOUtils.save(in, target.resolve(string));
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static InputStream getResource(String path, ClassLoader loader) {
        try {
            URL url = loader.getResource(path);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void save(InputStream in, Path target) throws IOException {
        byte[] buffer = new byte[in.available()];
        in.read(buffer);
        in.close();
        Files.write(target, buffer, new OpenOption[0]);
    }
}

