/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.utils;

import dev.frankheijden.insights.api.utils.MapUtils;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern placeholderPattern = Pattern.compile("%[0-9a-zA-Z]+%");

    private StringUtils() {
    }

    public static String replaceSmall(String str, String ... replacements) {
        if (replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Must be a multiple of two");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            str = str.replace("%" + replacements[i] + "%", replacements[i + 1]);
        }
        return str;
    }

    public static String replace(String str, String ... replacements) {
        return replacements.length < 10 ? StringUtils.replaceSmall(str, replacements) : StringUtils.replace(str, MapUtils.toMap(replacements));
    }

    public static String replace(String str, Map<String, String> replacements) {
        StringBuffer sb = new StringBuffer(str.length());
        Matcher matcher = placeholderPattern.matcher(str);
        while (matcher.find()) {
            String group = matcher.group();
            matcher.appendReplacement(sb, replacements.getOrDefault(group.substring(1, group.length() - 1), group));
        }
        return sb.toString();
    }

    public static String pretty(long n) {
        return NumberFormat.getIntegerInstance().format(n);
    }

    public static String pretty(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public static String prettyOneDecimal(double d) {
        return String.format("%,.1f", d);
    }

    public static List<String> findThatStartsWith(Collection<? extends String> collection, String input) {
        ArrayList<String> strings = new ArrayList<String>();
        input = input.toLowerCase(Locale.ENGLISH);
        for (String string : collection) {
            if (!string.startsWith(input)) continue;
            strings.add(string);
        }
        return strings;
    }

    public static String capitalizeSentence(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (String s : str.split(" ")) {
            sb.append(' ').append(StringUtils.capitalize(s));
        }
        return sb.substring(1);
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1);
    }

    public static String join(String[] strings, String delimiter, int fromIndex) {
        return StringUtils.join(strings, delimiter, fromIndex, strings.length);
    }

    public static String join(String[] strings, String delimiter, int fromIndex, int toIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = fromIndex; i < toIndex; ++i) {
            sb.append(delimiter).append(strings[i]);
        }
        return sb.length() == 0 ? "" : sb.substring(delimiter.length());
    }
}

