/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.api.utils;

import java.util.regex.Pattern;

public class VersionUtils {
    private static final Pattern integerPattern = Pattern.compile("[^0-9]");

    private VersionUtils() {
    }

    public static boolean isNewVersion(String oldVersion, String newVersion) {
        if (oldVersion == null || newVersion == null) {
            return false;
        }
        String[] oldVersionSplit = oldVersion.split("-")[0].split("\\.");
        String[] newVersionSplit = newVersion.split("-")[0].split("\\.");
        for (int i = 0; i < oldVersionSplit.length && i < newVersionSplit.length; ++i) {
            int o = VersionUtils.extractInteger(oldVersionSplit[i]);
            int n = VersionUtils.extractInteger(newVersionSplit[i]);
            if (i != oldVersionSplit.length - 1 && i != newVersionSplit.length - 1 && n < o) {
                return false;
            }
            if (n <= o) continue;
            return true;
        }
        return false;
    }

    private static int extractInteger(String str) {
        return Integer.parseInt(integerPattern.matcher(str).replaceAll(""));
    }
}

