/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands;

import dev.frankheijden.insights.Insights;
import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.commands.InsightsCommand;
import dev.frankheijden.insights.api.config.Messages;
import dev.frankheijden.insights.api.utils.ColorUtils;
import dev.frankheijden.insights.api.utils.StringUtils;
import dev.frankheijden.insights.concurrent.ContainerExecutorService;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Command;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Permission;
import org.bukkit.command.CommandSender;

@Command(value="insights|in")
public class CommandInsights
extends InsightsCommand {
    public CommandInsights(InsightsPlugin plugin) {
        super(plugin);
    }

    @Command(value="")
    @Permission(value={"insights.info"})
    private void showBase(CommandSender sender) {
        sender.sendMessage(ColorUtils.colorize("&8&l&m---------------=&r&8[ &b&lInsights&8 ]&l&m=----------------", "&b Plugin version: &a" + this.plugin.getDescription().getVersion(), "&b Plugin author(s): &7" + String.join((CharSequence)", ", this.plugin.getDescription().getAuthors()), "&b Plugin link: &7https://www.spigotmc.org/resources/56489/", "&b Wiki: &7https://github.com/InsightsPlugin/Insights/wiki", "&8&m-------------------------------------------------"));
    }

    @Command(value="reload")
    @Permission(value={"insights.reload"})
    private void reloadConfigurations(CommandSender sender) {
        this.plugin.reloadConfigs();
        this.plugin.reload();
        this.plugin.getMessages().getMessage(Messages.Key.CONFIGS_RELOADED).sendTo(sender);
    }

    @Command(value="stats")
    @Permission(value={"insights.stats"})
    private void displayStatistics(CommandSender sender) {
        ContainerExecutorService executor = ((Insights)this.plugin).getExecutor();
        this.plugin.getMessages().getMessage(Messages.Key.STATS).addTemplates(Messages.tagOf("chunks_scanned", StringUtils.pretty(executor.getCompletedTaskCount())), Messages.tagOf("blocks_scanned", StringUtils.pretty(this.plugin.getMetricsManager().getTotalBlocksScanned().sum())), Messages.tagOf("queue_size", StringUtils.pretty(executor.getQueueSize()))).sendTo(sender);
    }
}

