/*
 * Decompiled with CFR 0.152.
 */
package dev.frankheijden.insights.commands;

import dev.frankheijden.insights.api.InsightsPlugin;
import dev.frankheijden.insights.api.commands.InsightsCommand;
import dev.frankheijden.insights.api.concurrent.ScanOptions;
import dev.frankheijden.insights.api.config.limits.Limit;
import dev.frankheijden.insights.api.objects.wrappers.ScanObject;
import dev.frankheijden.insights.api.reflection.RTileEntityTypes;
import dev.frankheijden.insights.api.tasks.ScanTask;
import dev.frankheijden.insights.api.util.LazyChunkPartRadiusIterator;
import dev.frankheijden.insights.api.utils.Constants;
import dev.frankheijden.insights.core.dependencies.cloud.annotation.specifier.Range;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Argument;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Command;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Flag;
import dev.frankheijden.insights.core.dependencies.cloud.annotations.Permission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;

@Command(value="scan <radius>")
public class CommandScan
extends InsightsCommand {
    public CommandScan(InsightsPlugin plugin) {
        super(plugin);
    }

    @Command(value="tile")
    @Permission(value={"insights.scan.tile"})
    private void handleTileScan(Player player, @Argument(value="radius") @Range(min="0", max="256") int radius, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, radius, RTileEntityTypes.getTileEntities(), ScanOptions.materialsOnly(), false, groupByChunk);
    }

    @Command(value="entity")
    @Permission(value={"insights.scan.entity"})
    private void handleEntityScan(Player player, @Argument(value="radius") @Range(min="0", max="256") int radius, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, radius, Constants.SCAN_ENTITIES, ScanOptions.entitiesOnly(), false, groupByChunk);
    }

    @Command(value="all")
    @Permission(value={"insights.scan.all"})
    private void handleAllScan(Player player, @Argument(value="radius") @Range(min="0", max="256") int radius, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk) {
        this.handleScan(player, radius, null, ScanOptions.scanOnly(), false, groupByChunk);
    }

    @Command(value="custom <items>")
    @Permission(value={"insights.scan.custom"})
    private void handleCustomScan(Player player, @Argument(value="radius") @Range(min="0", max="256") int radius, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk, @Argument(value="items") ScanObject<?>[] items) {
        List<ScanObject<?>> scanObjects = Arrays.asList(items);
        boolean hasOnlyEntities = scanObjects.stream().allMatch(s -> s.getType() == ScanObject.Type.ENTITY);
        boolean hasOnlyMaterials = scanObjects.stream().allMatch(s -> s.getType() == ScanObject.Type.MATERIAL);
        ScanOptions options = hasOnlyEntities ? ScanOptions.entitiesOnly() : (hasOnlyMaterials ? ScanOptions.materialsOnly() : ScanOptions.scanOnly());
        this.handleScan(player, radius, new HashSet(scanObjects), options, true, groupByChunk);
    }

    @Command(value="limit <limit>")
    @Permission(value={"insights.scan.limit"})
    private void handleLimitScan(Player player, @Argument(value="radius") @Range(min="0", max="256") int radius, @Flag(value="group-by-chunk", aliases={"c"}) boolean groupByChunk, @Argument(value="limit") Limit limit) {
        this.handleScan(player, radius, limit.getScanObjects(), limit.getScanOptions(), false, groupByChunk);
    }

    public void handleScan(Player player, int radius, Set<? extends ScanObject<?>> items, ScanOptions options, boolean displayZeros, boolean groupByChunk) {
        Chunk chunk = player.getLocation().getChunk();
        World world = chunk.getWorld();
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        LazyChunkPartRadiusIterator it = new LazyChunkPartRadiusIterator(world, chunkX, chunkZ, radius);
        if (groupByChunk) {
            ScanTask.scanAndDisplayGroupedByChunk(this.plugin, player, it, it.getChunkCount(), options, items, false);
        } else {
            ScanTask.scanAndDisplay(this.plugin, player, it, it.getChunkCount(), options, items, displayZeros);
        }
    }
}

